/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.aksw.vshell.registry.DynamicInput;
import org.aksw.vshell.registry.InputBase;

public class FileInput
extends InputBase
implements DynamicInput {
    private Path path;

    protected FileInput(Path path, InputStream inputStream) {
        super(inputStream);
        this.path = path;
    }

    @Override
    public boolean hasFile() {
        return true;
    }

    @Override
    public Path getFile() {
        return this.path;
    }

    @Override
    protected InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public static FileInput of(Path path, InputStream inputStream) {
        return new FileInput(path, inputStream);
    }

    public static FileInput of(Path path) {
        return FileInput.of(path, null);
    }

    public static FileInput of(File file) {
        return FileInput.of(file.toPath());
    }

    public Path getPath() {
        return this.path;
    }
}

