/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.aksw.shellgebra.io.pipe.PosixPipe;
import org.aksw.vshell.registry.DynamicInput;
import org.aksw.vshell.registry.InputBase;
import org.apache.commons.io.input.ProxyInputStream;

public class DynamicInputFromStream
extends InputBase
implements DynamicInput {
    protected InputStream coreInput;
    protected PosixPipe pipe = null;
    protected CompletableFuture<?> pumpFuture = null;
    protected Object lock = new Object();

    @Override
    public InputStream openInputStream() throws IOException {
        return new DynamicInputStream(this.coreInput);
    }

    protected DynamicInputFromStream(InputStream coreInput) {
        super(null);
        this.coreInput = coreInput;
    }

    public static DynamicInputFromStream of(InputStream coreInput) {
        return new DynamicInputFromStream(coreInput);
    }

    @Override
    public boolean hasFile() {
        return this.pipe != null;
    }

    @Override
    public Path getFile() throws IOException {
        this.upgrade();
        return this.pipe.getReadEndProcPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade() throws IOException {
        if (this.pipe == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pipe == null) {
                    this.pipe = PosixPipe.open();
                    ((DynamicInputStream)((Object)this.inputStream())).setDelegate(this.pipe.getInputStream());
                    Runnable runnable = () -> {
                        try (OutputStream out = this.pipe.getOutputStream();){
                            this.coreInput.transferTo(out);
                            out.flush();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    };
                    this.pumpFuture = CompletableFuture.runAsync(runnable);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.coreInput.close();
        }
        finally {
            try {
                if (this.pipe != null) {
                    this.pipe.close();
                }
            }
            finally {
                if (this.pumpFuture != null) {
                    this.pumpFuture.cancel(true);
                    this.pumpFuture.join();
                }
            }
        }
    }

    private static class DynamicInputStream
    extends ProxyInputStream {
        public DynamicInputStream(InputStream proxy) {
            super(proxy);
        }

        public void setDelegate(InputStream proxy) {
            this.in = proxy;
        }
    }
}

