/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.Objects;
import java.util.Optional;
import org.aksw.shellgebra.shim.core.ArgsTransform;
import org.aksw.vshell.registry.CommandBinding;
import org.aksw.vshell.registry.CommandBindingLocator;
import org.aksw.vshell.registry.CommandLocator;

public class CommandBindingLocatorOverCommandLocator
implements CommandBindingLocator {
    private CommandLocator commandLocator;

    public CommandBindingLocatorOverCommandLocator(CommandLocator commandLocator) {
        this.commandLocator = Objects.requireNonNull(commandLocator);
    }

    @Override
    public Optional<CommandBinding> locate(String virtualCommandName) {
        Optional<String> location = this.commandLocator.locate(virtualCommandName);
        Optional<CommandBinding> result = location.map(loc -> new CommandBinding((String)loc, ArgsTransform.identity()));
        return result;
    }

    public static CommandBindingLocator of(CommandLocator commandLocator) {
        return new CommandBindingLocatorOverCommandLocator(commandLocator);
    }
}

