/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitor;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitorRenderAsBashString;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransform;
import org.aksw.shellgebra.exec.ListBuilder;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.shellgebra.processbuilder.ProcessBuilderGroup;
import org.aksw.shellgebra.processbuilder.ProcessBuilderPipeline;
import org.aksw.vshell.registry.CmdArgTransformToProcess;
import org.aksw.vshell.registry.ExecSiteToProcessDispatcher;

public abstract class CmdOpVisitorToBase
implements CmdOpVisitor<IProcessBuilderCore<?>> {
    private ExecSiteToProcessDispatcher dispatcher;
    private CmdArgVisitor<CmdArg> cmdArgTransformer;

    public CmdOpVisitorToBase(ExecSiteToProcessDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.cmdArgTransformer = new CmdArgTransformToProcess(this);
    }

    public ExecSiteToProcessDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public CmdArgVisitor<CmdArg> getCmdArgTransformer() {
        return this.cmdArgTransformer;
    }

    protected abstract IProcessBuilderCore<?> toProcessBuilder(List<String> var1);

    @Override
    public IProcessBuilderCore<?> visit(CmdOpExec op) {
        List<CmdArg> args = op.args().args();
        List<CmdArg> resolvedArgs = CmdArgTransform.transformArgs(this.cmdArgTransformer, args);
        List<String> resolvedArgStrs = CmdArgVisitorRenderAsBashString.render(resolvedArgs);
        List<String> argv = ListBuilder.ofString().add(op.getName()).addAll((Collection<String>)resolvedArgStrs).buildList();
        IProcessBuilderCore<?> result = this.toProcessBuilder(argv);
        return result;
    }

    @Override
    public IProcessBuilderCore<?> visit(CmdOpPipeline op) {
        List<CmdOp> subOps = op.subOps();
        ArrayList<IProcessBuilderCore> list = new ArrayList<IProcessBuilderCore>(subOps.size());
        for (CmdOp subOp : subOps) {
            IProcessBuilderCore newSubOp = (IProcessBuilderCore)subOp.accept(this);
            list.add(newSubOp);
        }
        return ProcessBuilderPipeline.of(list);
    }

    @Override
    public IProcessBuilderCore<?> visit(CmdOpGroup op) {
        List<CmdOp> subOps = op.subOps();
        ArrayList<IProcessBuilderCore> list = new ArrayList<IProcessBuilderCore>(subOps.size());
        for (CmdOp subOp : subOps) {
            IProcessBuilderCore newSubOp = (IProcessBuilderCore)subOp.accept(this);
            list.add(newSubOp);
        }
        return ProcessBuilderGroup.of(list);
    }

    @Override
    public IProcessBuilderCore<?> visit(CmdOpVar op) {
        IProcessBuilderCore<?> result = this.dispatcher.resolve(op);
        return result;
    }
}

