/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.core;

import java.util.List;
import java.util.Objects;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgRedirect;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;

public record ArgumentList(List<CmdArg> args) {
    public ArgumentList {
        args = List.copyOf(args);
    }

    public int size() {
        return this.args.size();
    }

    public static ArgumentList of(CmdArg ... args) {
        return new ArgumentList(List.of(args));
    }

    public static ArgumentList of(List<CmdArg> args) {
        return new ArgumentList(List.copyOf(args));
    }

    public static ArgumentList ofLiterals(List<String> args) {
        List<CmdArg> tmp = args.stream().map(CmdArg::ofLiteral).map(x -> x).toList();
        return new ArgumentList(tmp);
    }

    public List<CmdRedirect> getRedirects() {
        List<CmdRedirect> result = this.args.stream().map(arg -> {
            CmdRedirect cmdRedirect;
            if (arg instanceof CmdArgRedirect) {
                CmdArgRedirect ca = (CmdArgRedirect)arg;
                cmdRedirect = ca.redirect();
            } else {
                cmdRedirect = null;
            }
            return cmdRedirect;
        }).filter(Objects::nonNull).toList();
        return result;
    }

    public List<CmdArg> getRealArgs() {
        List<CmdArg> result = this.args.stream().filter(arg -> !(arg instanceof CmdArgRedirect)).toList();
        return result;
    }
}

