/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.commons.io.util.stream.OutputStreamTransform;
import org.aksw.shellgebra.shim.cmd.GenericCodecArgs;
import org.aksw.shellgebra.shim.cmd.InputStreamTransformOverCommonsCompress;
import org.aksw.shellgebra.shim.cmd.JvmCommandBase;
import org.aksw.shellgebra.shim.cmd.OutputStreamTransformOverCommonsCompress;
import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.vshell.registry.JvmExecCxt;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamProvider;

public class JvmCommandTranscode
extends JvmCommandBase<GenericCodecArgs> {
    private String codecName;
    private InputStreamTransform inTransform;
    private OutputStreamTransform outTransform;

    public JvmCommandTranscode(String codecName, InputStreamTransform inTransform, OutputStreamTransform outTransform) {
        this.codecName = codecName;
        this.inTransform = inTransform;
        this.outTransform = outTransform;
    }

    @Override
    public ArgsModular<GenericCodecArgs> parseArgs(String ... args) {
        ArgsModular<GenericCodecArgs> result = GenericCodecArgs.parse(args);
        return result;
    }

    @Override
    protected void runActual(JvmExecCxt cxt, GenericCodecArgs model) throws IOException {
        System.out.println("transcode called");
        if (model.isDecode()) {
            Objects.requireNonNull(this.inTransform, "No decoding for " + this.codecName);
            InputStream encodedIn = cxt.in().inputStream();
            InputStream decodedIn = this.inTransform.apply(encodedIn);
            OutputStream os = cxt.out().outputStream();
            System.out.println("transcode reading started.");
            decodedIn.transferTo(os);
            System.out.println("transcode terminated");
        } else {
            Objects.requireNonNull(this.inTransform, "No encoding for " + this.codecName);
            InputStream in = cxt.in().inputStream();
            OutputStream rawOut = cxt.out().outputStream();
            OutputStream out = this.outTransform.apply(rawOut);
            in.transferTo(out);
        }
    }

    public static JvmCommandTranscode of(CompressorStreamFactory provider, String codecName) {
        OutputStreamTransformOverCommonsCompress outTransform;
        Objects.requireNonNull(provider);
        Objects.requireNonNull(codecName);
        Set inNames = provider.getInputStreamCompressorNames();
        InputStreamTransformOverCommonsCompress inTransform = inNames.contains(codecName) ? new InputStreamTransformOverCommonsCompress((CompressorStreamProvider)provider, codecName) : null;
        Set outNames = provider.getOutputStreamCompressorNames();
        OutputStreamTransformOverCommonsCompress outputStreamTransformOverCommonsCompress = outTransform = outNames.contains(codecName) ? new OutputStreamTransformOverCommonsCompress((CompressorStreamProvider)provider, codecName) : null;
        if (inTransform == null && outTransform == null) {
            throw new NoSuchElementException("No transcoding with name: " + codecName);
        }
        return new JvmCommandTranscode(codecName, inTransform, outTransform);
    }
}

