/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.cmd;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.aksw.shellgebra.shim.cmd.ArgsCat;
import org.aksw.shellgebra.shim.cmd.JvmCommandBase;
import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.vshell.registry.JvmExecCxt;
import org.apache.commons.exec.ExecuteException;

public class JvmCommandCat
extends JvmCommandBase<ArgsCat> {
    @Override
    public ArgsModular<ArgsCat> parseArgs(String ... args) {
        ArgsModular<ArgsCat> result = ArgsCat.parse(args);
        return result;
    }

    @Override
    public void runActual(JvmExecCxt cxt, ArgsCat model) throws ExecuteException {
        boolean exitValue = false;
        List<String> names = model.getFileNames().isEmpty() ? List.of("-") : model.getFileNames();
        for (String name : names) {
            try {
                if (name.equals("-")) {
                    cxt.in().inputStream().transferTo(cxt.out().outputStream());
                    continue;
                }
                Path path = Path.of(name, new String[0]);
                InputStream in = Files.newInputStream(path, new OpenOption[0]);
                try {
                    in.transferTo(cxt.out().outputStream());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(cxt.err().printStream());
                exitValue = true;
                break;
            }
        }
        if (exitValue) {
            throw new ExecuteException("One or more arguments failed to open as files.", 1);
        }
    }
}

