/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.shellgebra.shim.core.ArgumentListBuilder;
import org.aksw.shellgebra.shim.picocli.ArgsParserPicocli;
import picocli.CommandLine;

public class ArgsHead {
    @CommandLine.Option(names={"-n", "--lines"}, description={"Lines"})
    private Long lines = null;
    @CommandLine.Parameters(arity="0..*", description={"File names"})
    public List<String> fileNames = new ArrayList<String>();

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public Optional<Long> getLines() {
        return Optional.ofNullable(this.lines);
    }

    public String toString() {
        return "ArgsCat [fileNames=" + String.valueOf(this.fileNames) + "]";
    }

    public static ArgumentList renderArgList(ArgsHead model) {
        ArgumentList result = ArgumentListBuilder.newBuilder().opt("-n", Long.toString((Long)model.getLines().orElse(null))).files(model.getFileNames()).build();
        return result;
    }

    public static Boolean stdinTest(ArgsHead args) {
        return args.getFileNames().isEmpty() || args.getFileNames().contains("-");
    }

    public static ArgsModular<ArgsHead> parse(String[] args) {
        ArgsHead model = ArgsParserPicocli.of(ArgsHead::new).parse(args);
        return new ArgsModular<ArgsHead>(model, ArgsHead::renderArgList, ArgsHead::stdinTest);
    }
}

