/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.registry.tool;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.shellgebra.registry.tool.CommandTargetInfoImpl;
import org.aksw.shellgebra.registry.tool.model.CommandTargetInfo;
import org.aksw.shellgebra.registry.tool.model.ToolInfo;

public class ToolInfoImpl
implements ToolInfo {
    protected String name;
    protected Map<String, CommandTargetInfoImpl> commandMap;
    protected Optional<Boolean> absentOnHost = null;
    protected Set<String> absenceInDockerImages = new LinkedHashSet<String>();

    public ToolInfoImpl(String name) {
        this(name, new LinkedHashMap<String, CommandTargetInfoImpl>(), new LinkedHashSet<String>());
    }

    private ToolInfoImpl(String name, Map<String, CommandTargetInfoImpl> commandMap, Set<String> absenceInDockerImages) {
        this.name = name;
        this.commandMap = commandMap;
        this.absenceInDockerImages = absenceInDockerImages;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Stream<String> getAbsenceInDockerImages() {
        return this.absenceInDockerImages.stream();
    }

    @Override
    public boolean isAbsentInDockerImage(String dockerImage) {
        return this.absenceInDockerImages.contains(dockerImage);
    }

    public void setAbsentOnHost(Boolean value) {
        this.absentOnHost = Optional.ofNullable(value);
    }

    @Override
    public Optional<Boolean> getAbsentOnHost() {
        return this.absentOnHost;
    }

    public ToolInfoImpl setAbsentInDockerImage(String dockerImage) {
        this.absenceInDockerImages.add(dockerImage);
        return this;
    }

    @Override
    public CommandTargetInfoImpl findCommandByImage(String imageName) {
        CommandTargetInfoImpl result = this.commandMap.values().stream().filter(cpi -> cpi.getDockerImages().anyMatch(img -> img.equals(imageName))).findFirst().orElse(null);
        return result;
    }

    @Override
    public CommandTargetInfoImpl findCommandOnHost() {
        CommandTargetInfoImpl result = this.commandMap.values().stream().filter(cpi -> Boolean.TRUE.equals(cpi.getAvailableOnHost())).findFirst().orElse(null);
        return result;
    }

    public CommandTargetInfoImpl getOrCreateCommand(String commandPath) {
        return this.commandMap.computeIfAbsent(commandPath, n -> new CommandTargetInfoImpl(commandPath));
    }

    public ToolInfoImpl clone() {
        Map newCmdMap = this.commandMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((CommandTargetInfoImpl)e.getValue()).clone(), (u, v) -> u, LinkedHashMap::new));
        return new ToolInfoImpl(this.name, newCmdMap, new LinkedHashSet<String>(this.absenceInDockerImages));
    }

    public String toString() {
        return "ToolInfo [name=" + this.name + ", commandTargets=" + String.valueOf(this.commandMap.values()) + ", absentOnHost=" + String.valueOf(this.absentOnHost) + ", absences: " + String.valueOf(this.absenceInDockerImages) + "]";
    }

    @Override
    public Stream<CommandTargetInfo> list() {
        return null;
    }

    @Override
    public Optional<CommandTargetInfo> getCommand(String commandPath) {
        return Optional.empty();
    }
}

