/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.processbuilder.ProcessBuilderBase;
import org.aksw.shellgebra.processbuilder.ProcessDockerExecResult;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class ProcessBuilderDockerExec
extends ProcessBuilderBase<ProcessBuilderDockerExec> {
    private GenericContainer<?> container;

    public ProcessBuilderDockerExec(GenericContainer<?> container) {
        this.container = container;
    }

    @Override
    public boolean supportsAnonPipeRead() {
        return false;
    }

    @Override
    public boolean supportsAnonPipeWrite() {
        return false;
    }

    @Override
    public boolean supportsDirectNamedPipe() {
        return true;
    }

    @Override
    public boolean accessesStdIn() {
        return true;
    }

    @Override
    protected ProcessBuilderDockerExec cloneActual() {
        return new ProcessBuilderDockerExec(this.container);
    }

    @Override
    public Process start(ProcessRunner executor) throws IOException {
        Container.ExecResult execResult;
        String[] argv = (String[])Objects.requireNonNull(this.command()).toArray(String[]::new);
        try {
            execResult = this.container.execInContainer(StandardCharsets.UTF_8, argv);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new ProcessDockerExecResult(execResult);
    }
}

