/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.io.pipe;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.aksw.shellgebra.io.pipe.PosixPipe;
import org.aksw.shellgebra.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedPipe {
    private static final Logger logger = LoggerFactory.getLogger(NamedPipe.class);
    private static final int S_IFMT = 61440;
    private static final int S_IFIFO = 4096;

    public static boolean isFifoType(Path path, boolean followSymlinks) throws IOException {
        LinkOption[] linkOptionArray;
        if (followSymlinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] opts = linkOptionArray;
        Map<String, Object> attrs = Files.readAttributes(path, "unix:mode", opts);
        int mode = (Integer)attrs.get("mode");
        return (mode & 0xF000) == 4096;
    }

    public static boolean isNamedPipe(Path path, boolean followSymlinks) throws IOException {
        boolean result = NamedPipe.isFifoType(path, followSymlinks) && !PosixPipe.isAnonymousProcPipe(path);
        return result;
    }

    public static void create(Path path) throws IOException {
        String absPathStr = path.toAbsolutePath().toString();
        String resolvedCmd = SystemUtils.which("mkfifo");
        SystemUtils.runAndWait(arg_0 -> ((Logger)logger).info(arg_0), resolvedCmd, absPathStr);
    }

    public static Path newNamedPipePath() throws IOException {
        String baseDir = System.getProperty("java.io.tmpdir");
        String fileName = "named-pipe-" + System.nanoTime();
        Path result = Path.of(baseDir, new String[0]).resolve(fileName);
        return result;
    }

    public static Path create() throws IOException {
        Path result = NamedPipe.newNamedPipePath();
        NamedPipe.create(result);
        return result;
    }
}

