/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.aksw.shellgebra.exec.stage.FileWriterTaskBase;
import org.aksw.shellgebra.util.PathLifeCycle;

public abstract class FileWriterTaskViaExecutor
extends FileWriterTaskBase {
    protected Object lock = new Object();
    private Thread taskThread = null;

    public FileWriterTaskViaExecutor(Path path, PathLifeCycle pathLifeCycle) {
        super(path, pathLifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfAbortHasBeenCalled();
            this.checkIfNew();
            this.state.set(FileWriterTaskBase.TaskState.STARTING);
            this.taskThread = new Thread(new Worker());
            this.taskThread.start();
        }
    }

    @Override
    public void waitForCompletion() throws InterruptedException, ExecutionException {
        if (this.state.get() == FileWriterTaskBase.TaskState.NEW) {
            throw new IllegalStateException("Task has not been started.");
        }
        if (this.taskThread != null) {
            this.taskThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void abort() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAbortCalled) {
                boolean wasRunning;
                this.state.compareAndSet(FileWriterTaskBase.TaskState.NEW, FileWriterTaskBase.TaskState.TERMINATED);
                this.isAbortCalled = true;
                boolean bl = wasRunning = this.state.get() == FileWriterTaskBase.TaskState.RUNNING || this.state.get() == FileWriterTaskBase.TaskState.STARTING;
                if (wasRunning) {
                    try {
                        this.abortActual();
                    }
                    finally {
                        if (this.taskThread.isAlive()) {
                            this.taskThread.interrupt();
                        }
                    }
                }
            }
        }
    }

    protected abstract void abortActual();

    @Override
    protected void onCompletion() throws IOException {
    }

    @Override
    public final void close() throws Exception {
        try {
            this.abort();
            this.waitForCompletion();
        }
        finally {
            try {
                this.closeActual();
            }
            finally {
                if (this.taskThread != null) {
                    this.taskThread.interrupt();
                    this.taskThread.join();
                }
            }
        }
    }

    protected void closeActual() throws Exception {
    }

    public String toString() {
        return "(executorFileWriter " + String.valueOf(this.getOutputPath()) + "/" + String.valueOf(this.pathLifeCycle) + ")";
    }

    protected class Worker
    implements Runnable {
        boolean lifeCycleStarted = false;

        protected Worker() {
        }

        @Override
        public void run() {
            try {
                this.runInternal();
            }
            finally {
                this.cleanup();
            }
        }

        protected void cleanup() {
            if (this.lifeCycleStarted) {
                try {
                    FileWriterTaskViaExecutor.this.pathLifeCycle.afterExec(FileWriterTaskViaExecutor.this.outputPath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runInternal() {
            Object object = FileWriterTaskViaExecutor.this.lock;
            synchronized (object) {
                FileWriterTaskViaExecutor.this.checkIfAbortHasBeenCalled();
                FileWriterTaskViaExecutor.this.state.set(FileWriterTaskBase.TaskState.RUNNING);
                try {
                    this.lifeCycleStarted = true;
                    FileWriterTaskViaExecutor.this.pathLifeCycle.beforeExec(FileWriterTaskViaExecutor.this.outputPath);
                    FileWriterTaskViaExecutor.this.prepareWriteFile();
                }
                catch (Exception e) {
                    FileWriterTaskViaExecutor.this.state.set(FileWriterTaskBase.TaskState.TERMINATED);
                    throw new RuntimeException(e);
                }
            }
            try {
                FileWriterTaskViaExecutor.this.checkIfAbortHasBeenCalled();
                FileWriterTaskViaExecutor.this.runWriteFile();
                FileWriterTaskViaExecutor.this.state.compareAndSet(FileWriterTaskBase.TaskState.RUNNING, FileWriterTaskBase.TaskState.TERMINATED);
            }
            catch (IOException e) {
                FileWriterTaskViaExecutor.this.state.compareAndSet(FileWriterTaskBase.TaskState.RUNNING, FileWriterTaskBase.TaskState.TERMINATED);
                throw new CompletionException(e);
            }
            finally {
                try {
                    Object object2 = FileWriterTaskViaExecutor.this.lock;
                    synchronized (object2) {
                        FileWriterTaskViaExecutor.this.onCompletion();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

