/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.exec.stage.FileWriterTaskBase;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class FileWriterTaskFromContainer
extends FileWriterTaskBase {
    private Logger logger = LoggerFactory.getLogger(FileWriterTaskFromContainer.class);
    private GenericContainer<?> container;
    private List<FileWriterTask> subTasks;

    public FileWriterTaskFromContainer(GenericContainer<?> container, Path path, PathLifeCycle pathLifeCycle, List<FileWriterTask> subTasks) {
        super(path, pathLifeCycle);
        this.container = container;
        this.subTasks = subTasks;
    }

    @Override
    protected void prepareWriteFile() throws IOException {
    }

    @Override
    protected void runWriteFile() throws IOException {
        this.pathLifeCycle.beforeExec(this.outputPath);
        for (FileWriterTask subTask : this.subTasks) {
            subTask.start();
        }
        this.container.start();
    }

    @Override
    public void start() {
        try {
            this.runWriteFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        try {
            this.container.close();
        }
        finally {
            for (FileWriterTask subTask : this.subTasks) {
                try {
                    subTask.close();
                }
                catch (Exception e) {
                    this.logger.warn("Failure while closing sub task.", (Throwable)e);
                }
            }
            this.pathLifeCycle.afterExec(this.outputPath);
        }
    }

    @Override
    protected void onCompletion() throws IOException {
    }

    @Override
    public void waitForCompletion() throws ExecutionException, InterruptedException {
        ((WaitContainerResultCallback)this.container.getDockerClient().waitContainerCmd(this.container.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitCompletion();
    }

    @Override
    public void abort() {
        this.container.close();
    }
}

