/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.google.common.io.ByteSource;
import java.nio.file.Path;
import java.util.Objects;
import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.TransformedByteSource;
import org.aksw.shellgebra.exec.stage.BoundStage;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.exec.stage.FileWriterTaskFromByteSource;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.aksw.shellgebra.util.PathLifeCycles;

public class BoundStageJvm
implements BoundStage {
    private ByteSource byteSource;
    private InputStreamTransform transform;

    public BoundStageJvm(ByteSource byteSource, InputStreamTransform transform) {
        this.byteSource = Objects.requireNonNull(byteSource);
        this.transform = Objects.requireNonNull(transform);
    }

    @Override
    public ByteSource toByteSource() {
        return TransformedByteSource.transform(this.byteSource, this.transform);
    }

    @Override
    public FileWriterTask execToRegularFile(Path hostPath) {
        ByteSource bs = this.toByteSource();
        return new FileWriterTaskFromByteSource(hostPath, PathLifeCycles.none(), bs);
    }

    @Override
    public FileWriterTask execToFile(Path hostPath, PathLifeCycle pathLifeCycle) {
        ByteSource bs = this.toByteSource();
        return new FileWriterTaskFromByteSource(hostPath, PathLifeCycles.none(), bs);
    }

    @Override
    public FileWriterTask runToHostPipe() {
        ByteSource bs = this.toByteSource();
        PathLifeCycle pathLifeCycle = PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe());
        Path tempFile = FileMapper.allocateTempPath("", "");
        return new FileWriterTaskFromByteSource(tempFile, pathLifeCycle, bs);
    }
}

