/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class ReferenceCountedObject<T> {
    private final T resource;
    private final AutoCloseable closeAction;
    private final AtomicInteger refCount = new AtomicInteger(1);

    private ReferenceCountedObject(T resource, AutoCloseable closeAction) {
        this.resource = Objects.requireNonNull(resource);
        this.closeAction = Objects.requireNonNull(closeAction);
    }

    public T get() {
        if (this.refCount.get() <= 0) {
            throw new IllegalStateException("Resource already released");
        }
        return this.resource;
    }

    public T getRaw() {
        return this.resource;
    }

    public ReferenceCountedObject<T> acquire() {
        this.refCount.getAndUpdate(old -> old > 0 ? old + 1 : 0);
        return this;
    }

    public void release() {
        int oldCount = this.refCount.decrementAndGet();
        if (oldCount < 0) {
            throw new IllegalStateException("Resource reference count negative \u2014 double close?");
        }
        if (oldCount == 0) {
            try {
                System.out.println("Closing resource: " + String.valueOf(this));
                this.closeAction.close();
            }
            catch (Exception e) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
        }
    }

    public boolean isOpen() {
        return this.refCount.get() > 0;
    }

    public int refCount() {
        return this.refCount.get();
    }

    public static <T extends AutoCloseable> ReferenceCountedObject<T> of(T obj) {
        return ReferenceCountedObject.of(obj, obj);
    }

    public static <T> ReferenceCountedObject<T> of(T obj, AutoCloseable closeAction) {
        return new ReferenceCountedObject<T>(obj, closeAction);
    }
}

