/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import org.aksw.shellgebra.exec.IProcessBuilder;
import org.aksw.vshell.registry.FileInput;
import org.aksw.vshell.registry.FileOutput;
import org.aksw.vshell.registry.JvmCommandRegistry;

public interface ProcessRunner
extends AutoCloseable {
    public JvmCommandRegistry getJvmCmdRegistry();

    public Map<String, String> environment();

    public Path directory();

    public Path inputPipe();

    public Path outputPipe();

    public Path errorPipe();

    public FileInput internalIn();

    public FileOutput internalOut();

    public FileOutput internalErr();

    public PrintStream internalPrintOut();

    public PrintStream internalPrintErr();

    public Thread setOutputReader(Consumer<InputStream> var1);

    default public Thread setOutputLineReaderUtf8(Consumer<String> lineCallback) {
        return this.setOutputLineReader(StandardCharsets.UTF_8, lineCallback);
    }

    default public Thread setOutputLineReader(Charset charset, Consumer<String> lineCallback) {
        return this.setOutputReader(in -> ProcessRunner.readLines(in, charset, lineCallback));
    }

    public Thread setErrorReader(Consumer<InputStream> var1);

    default public Thread setErrorLineReaderUtf8(Consumer<String> lineCallback) {
        return this.setErrorLineReader(StandardCharsets.UTF_8, lineCallback);
    }

    default public Thread setErrorLineReader(Charset charset, Consumer<String> lineCallback) {
        return this.setErrorReader(in -> ProcessRunner.readLines(in, charset, lineCallback));
    }

    public Thread setInputGenerator(Consumer<OutputStream> var1);

    default public Thread setInputPrintStreamUtf8(Consumer<PrintStream> writerCallback) {
        return this.setInputPrintStream(StandardCharsets.UTF_8, true, writerCallback);
    }

    default public Thread setInputPrintStream(Charset charset, boolean autoFlush, Consumer<PrintStream> writerCallback) {
        return this.setInputGenerator(out -> writerCallback.accept(new PrintStream((OutputStream)out, autoFlush, charset)));
    }

    public OutputStream getOutputStream();

    public InputStream getInputStream();

    public InputStream getErrorStream();

    public IProcessBuilder<?> configure(IProcessBuilder<?> var1);

    public void shutdown() throws IOException;

    public static void readLines(InputStream in, Charset charset, Consumer<String> lineCallback) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, charset));){
            br.lines().forEach(lineCallback::accept);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

