/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aksw.shellgebra.exec.graph.FdResource;
import org.aksw.shellgebra.exec.graph.FdTable;

public class ProcessCxt
implements AutoCloseable {
    private Map<String, String> environment;
    private Path directory;
    private FdTable<FdResource> fdTable;

    public ProcessCxt() {
        this(new ConcurrentHashMap<String, String>(), Path.of("", new String[0]), new FdTable<FdResource>());
    }

    private ProcessCxt(Map<String, String> environment, Path directory, FdTable<FdResource> fdTable) {
        this.environment = environment;
        this.directory = directory;
        this.fdTable = fdTable;
    }

    public FdTable<FdResource> getFdTable() {
        return this.fdTable;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public ProcessCxt dup() {
        return new ProcessCxt(new ConcurrentHashMap<String, String>(this.environment), this.directory, this.fdTable.dup());
    }

    @Override
    public void close() {
        this.fdTable.close();
    }
}

