/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.util.concurrent.atomic.AtomicBoolean;
import org.aksw.shellgebra.exec.graph.FileDescription;
import org.aksw.shellgebra.exec.graph.ReferenceCountedObject;

public class FileDescriptionImpl<T>
implements FileDescription<T> {
    private ReferenceCountedObject<T> resource;
    private AtomicBoolean isClosed = new AtomicBoolean();

    public FileDescriptionImpl(ReferenceCountedObject<T> resource) {
        this.resource = resource;
    }

    @Override
    public boolean isOpen() {
        return this.resource.isOpen();
    }

    @Override
    public T get() {
        return this.resource.get();
    }

    @Override
    public T getRaw() {
        return this.resource.getRaw();
    }

    @Override
    public FileDescription<T> dup() {
        this.resource.acquire();
        return new FileDescriptionImpl<T>(this.resource);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.resource.release();
        }
    }
}

