/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.commons.io.util.stream.OutputStreamTransform;
import org.aksw.commons.io.util.stream.OutputStreamTransformList;
import org.aksw.shellgebra.exec.stage.ByteSourceWrapper;

public class TransformedByteSource
extends ByteSourceWrapper {
    private List<InputStreamTransform> transforms;

    public TransformedByteSource(ByteSource delegate, List<InputStreamTransform> transforms) {
        super(Objects.requireNonNull(delegate));
        this.transforms = List.copyOf(transforms);
    }

    public List<InputStreamTransform> getTransforms() {
        return this.transforms;
    }

    @Override
    public InputStream openStream() throws IOException {
        ByteSource d = this.getDelegate();
        InputStream r = d.openStream();
        for (InputStreamTransform xform : this.transforms) {
            try {
                InputStream tmp = xform.apply(r);
                Objects.requireNonNull(tmp, "Transform must not return null");
                r = tmp;
            }
            catch (IOException | RuntimeException t) {
                t.addSuppressed(new RuntimeException("Error applying stream transform"));
                r.close();
                throw t;
            }
        }
        return r;
    }

    public static ByteSource transform(ByteSource bs, InputStreamTransform transform) {
        TransformedByteSource result;
        if (bs instanceof TransformedByteSource) {
            TransformedByteSource tbs = (TransformedByteSource)bs;
            ByteSource delegate = tbs.getDelegate();
            List<InputStreamTransform> before = tbs.getTransforms();
            ArrayList<InputStreamTransform> after = new ArrayList<InputStreamTransform>(before.size() + 1);
            after.addAll(before);
            after.add(transform);
            result = new TransformedByteSource(delegate, after);
        } else {
            result = new TransformedByteSource(bs, List.of(transform));
        }
        return result;
    }

    public static ByteSourceSplit split(ByteSource bs) {
        ByteSourceSplit result;
        if (bs instanceof TransformedByteSource) {
            List<InputStreamTransform> after;
            InputStreamTransform ist;
            int i;
            TransformedByteSource tbs = (TransformedByteSource)bs;
            ByteSource delegate = tbs.getDelegate();
            List<InputStreamTransform> before = tbs.getTransforms();
            ArrayList<OutputStreamTransform> suffix = new ArrayList<OutputStreamTransform>(before.size());
            for (i = before.size() - 1; i >= 0 && (ist = before.get(i)).isPiped(); --i) {
                OutputStreamTransform ost = ist.asOutputStreamTransform();
                suffix.add(ost);
            }
            OutputStreamTransformList outTransforms = new OutputStreamTransformList(suffix);
            result = (after = before.subList(0, ++i)).isEmpty() ? new ByteSourceSplit(delegate, outTransforms) : new ByteSourceSplit(new TransformedByteSource(delegate, after), outTransforms);
        } else {
            result = new ByteSourceSplit(bs, new OutputStreamTransformList());
        }
        return result;
    }

    public record ByteSourceSplit(ByteSource byteSource, OutputStreamTransformList outTransforms) {
    }
}

