/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.aksw.commons.util.docker.Argv;
import org.aksw.shellgebra.exec.CmdStrOps;
import org.aksw.shellgebra.exec.IProcessBuilder;
import org.aksw.shellgebra.exec.SysRuntimeCore;
import org.aksw.shellgebra.processbuilder.ProcessBuilderDockerExec;
import org.aksw.vshell.registry.JvmExecUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class SysRuntimeCoreDocker
implements SysRuntimeCore {
    private GenericContainer<?> container;
    private Argv entrypoint;
    private CmdStrOps cmdStrOps;

    public SysRuntimeCoreDocker(GenericContainer<?> container, Argv entrypoint, CmdStrOps cmdStrOps) {
        this.container = container;
        this.entrypoint = entrypoint;
        this.cmdStrOps = cmdStrOps;
    }

    public String getImageRef() {
        return this.container.getDockerImageName();
    }

    public Argv getEntrypoint() {
        return this.entrypoint;
    }

    public CmdStrOps getCmdStrOps() {
        return this.cmdStrOps;
    }

    @Override
    public IProcessBuilder<?> newProcessBuilder() {
        return new ProcessBuilderDockerExec(this.container);
    }

    @Override
    public String execCmd(String ... argv) throws IOException, InterruptedException {
        Container.ExecResult execResult = this.container.execInContainer(StandardCharsets.UTF_8, argv);
        String result = execResult.getStdout();
        result = JvmExecUtils.removeTrailingNewline(result);
        return result;
    }

    @Override
    public int runCmd(String ... argv) throws IOException, InterruptedException {
        Container.ExecResult execResult = this.container.execInContainer(StandardCharsets.UTF_8, argv);
        int result = execResult.getExitCode();
        return result;
    }

    @Override
    public void close() {
        this.container.stop();
    }
}

