/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.exec.CmdStrOps;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.newsclub.net.unix.FileDescriptorCast;

public interface SysRuntime
extends AutoCloseable {
    public String which(String var1) throws IOException, InterruptedException;

    public boolean exists(String var1) throws IOException, InterruptedException;

    public String quoteFileArgument(String var1);

    public CmdString compileString(CmdOp var1);

    public String[] compileCommand(CmdOp var1);

    public CmdStrOps getStrOps();

    public void createNamedPipe(Path var1) throws IOException;

    default public String[] resolveCommand(String ... argv) throws IOException, InterruptedException {
        Objects.requireNonNull(argv);
        if (argv.length == 0) {
            throw new IllegalArgumentException("Command must not be an empty array.");
        }
        String cmdName = argv[0];
        String resolvedName = this.which(cmdName);
        if (resolvedName == null) {
            throw new RuntimeException("Command not found: " + cmdName);
        }
        String[] result = Arrays.copyOf(argv, argv.length);
        result[0] = resolvedName;
        return result;
    }

    public static CmdString toString(CmdOp cmdOp) {
        SysRuntime runtime = SysRuntimeImpl.forCurrentOs();
        CmdString cmdString = runtime.compileString(cmdOp);
        return cmdString;
    }

    @Override
    public void close();

    public static Path getFdPath(FileDescriptor fd) {
        int fdVal;
        try {
            fdVal = (Integer)FileDescriptorCast.using((FileDescriptor)fd).as(Integer.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        long pid = ProcessHandle.current().pid();
        Path result = Path.of("/proc", Long.toString(pid), "fd", Integer.toString(fdVal));
        return result;
    }

    private static int extractFD(FileDescriptor fd) {
        try {
            Field field = FileDescriptor.class.getDeclaredField("fd");
            field.setAccessible(true);
            return (Integer)field.get(fd);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

