/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.docker.adapter.cli;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ContainerDef {
    private static final Logger log = LoggerFactory.getLogger(ContainerDef.class);
    private RemoteDockerImage image;
    Set<ExposedPort> exposedPorts = new LinkedHashSet<ExposedPort>();
    Set<PortBinding> portBindings = new HashSet<PortBinding>();
    Map<String, String> labels = new HashMap<String, String>();
    Map<String, String> envVars = new HashMap<String, String>();
    private String[] entrypoint;
    private String[] command = new String[0];
    private Network network;
    Set<String> networkAliases = new LinkedHashSet<String>();
    private String networkMode;
    List<Bind> binds = new ArrayList<Bind>();
    private boolean privilegedMode;
    private WaitStrategy waitStrategy = Wait.defaultWaitStrategy();

    protected void applyTo(CreateContainerCmd createCommand) {
        boolean shouldCheckFileMountingSupport;
        HostConfig hostConfig = createCommand.getHostConfig();
        if (hostConfig == null) {
            hostConfig = new HostConfig();
            createCommand.withHostConfig(hostConfig);
        }
        HashMap<ExposedPort, PortBinding> allPortBindings = new HashMap<ExposedPort, PortBinding>();
        for (ExposedPort exposedPort : this.exposedPorts) {
            allPortBindings.put(exposedPort, new PortBinding(Ports.Binding.empty(), exposedPort));
        }
        for (PortBinding portBinding : this.portBindings) {
            allPortBindings.put(portBinding.getExposedPort(), portBinding);
        }
        hostConfig.withPortBindings(new ArrayList(allPortBindings.values()));
        createCommand.withExposedPorts(new ArrayList(allPortBindings.keySet()));
        createCommand.withEnv((String[])this.envVars.entrySet().stream().filter(it -> it.getValue() != null).map(it -> (String)it.getKey() + "=" + (String)it.getValue()).toArray(String[]::new));
        if (this.entrypoint != null) {
            createCommand.withEntrypoint(this.entrypoint);
        }
        if (this.command != null) {
            createCommand.withCmd(this.command);
        }
        if (this.network != null) {
            hostConfig.withNetworkMode(this.network.getId());
            createCommand.withAliases(this.networkAliases.toArray(new String[0]));
        } else if (this.networkMode != null) {
            createCommand.getHostConfig().withNetworkMode(this.networkMode);
        }
        boolean bl = shouldCheckFileMountingSupport = this.binds.size() > 0 && !TestcontainersConfiguration.getInstance().isDisableChecks();
        if (shouldCheckFileMountingSupport && !DockerClientFactory.instance().isFileMountingSupported()) {
            log.warn("Unable to mount a file from test host into a running container. This may be a misconfiguration or limitation of your Docker environment. Some features might not work.");
        }
        hostConfig.withBinds(this.binds.toArray(new Bind[0]));
        if (this.privilegedMode) {
            createCommand.getHostConfig().withPrivileged(Boolean.valueOf(this.privilegedMode));
        }
        HashMap<String, String> combinedLabels = new HashMap<String, String>(this.labels);
        if (createCommand.getLabels() != null) {
            combinedLabels.putAll(createCommand.getLabels());
        }
        createCommand.withLabels(combinedLabels);
    }

    protected void setImage(RemoteDockerImage image) {
        this.image = image;
    }

    protected void setImage(String image) {
        this.setImage(DockerImageName.parse((String)image));
    }

    protected void setImage(DockerImageName image) {
        this.setImage(new RemoteDockerImage(image));
    }

    public RemoteDockerImage getImage() {
        return this.image;
    }

    public Set<ExposedPort> getExposedPorts() {
        return new LinkedHashSet<ExposedPort>(this.exposedPorts);
    }

    protected void setExposedPorts(Set<ExposedPort> exposedPorts) {
        this.exposedPorts.clear();
        this.exposedPorts.addAll(exposedPorts);
    }

    protected void addExposedPorts(ExposedPort ... exposedPorts) {
        this.exposedPorts.addAll(Arrays.asList(exposedPorts));
    }

    protected void addExposedPort(ExposedPort exposedPort) {
        this.exposedPorts.add(exposedPort);
    }

    protected void setExposedTcpPorts(Set<Integer> ports) {
        this.exposedPorts.clear();
        ports.forEach(port -> this.exposedPorts.add(ExposedPort.tcp((int)port)));
    }

    protected void addExposedTcpPorts(int ... ports) {
        for (int port : ports) {
            this.exposedPorts.add(ExposedPort.tcp((int)port));
        }
    }

    protected void addExposedTcpPort(int port) {
        this.exposedPorts.add(ExposedPort.tcp((int)port));
    }

    protected void addExposedPort(int port, InternetProtocol protocol) {
        this.exposedPorts.add(new ExposedPort(port, protocol));
    }

    public Set<PortBinding> getPortBindings() {
        return new HashSet<PortBinding>(this.portBindings);
    }

    protected void setPortBindings(Set<PortBinding> portBindings) {
        this.portBindings.clear();
        this.portBindings.addAll(portBindings);
    }

    protected void addPortBindings(PortBinding ... portBindings) {
        this.portBindings.addAll(Arrays.asList(portBindings));
    }

    protected void addPortBinding(PortBinding portBinding) {
        this.portBindings.add(portBinding);
    }

    public Map<String, String> getLabels() {
        return new HashMap<String, String>(this.labels);
    }

    protected void setLabels(Map<String, String> labels) {
        this.labels.clear();
        this.labels.putAll(labels);
    }

    protected void addLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
    }

    protected void addLabel(String key, String value) {
        this.labels.put(key, value);
    }

    public Map<String, String> getEnvVars() {
        return new HashMap<String, String>(this.envVars);
    }

    protected void setEnvVars(Map<String, String> envVars) {
        this.envVars.clear();
        this.envVars.putAll(envVars);
    }

    protected void addEnvVars(Map<String, String> envVars) {
        this.envVars.putAll(envVars);
    }

    protected void addEnvVar(String key, String value) {
        this.envVars.put(key, value);
    }

    public String[] getEntrypoint() {
        return Arrays.copyOf(this.entrypoint, this.entrypoint.length);
    }

    protected void setEntrypoint(String ... entrypoint) {
        this.entrypoint = entrypoint;
    }

    public String[] getCommand() {
        return Arrays.copyOf(this.command, this.command.length);
    }

    protected void setCommand(String ... command) {
        this.command = command;
    }

    protected void setNetwork(Network network) {
        this.network = network;
    }

    public Network getNetwork() {
        return this.network;
    }

    public Set<String> getNetworkAliases() {
        return new LinkedHashSet<String>(this.networkAliases);
    }

    protected void setNetworkAliases(Set<String> aliases) {
        this.networkAliases.clear();
        this.networkAliases.addAll(aliases);
    }

    protected void addNetworkAliases(String ... aliases) {
        this.networkAliases.addAll(Arrays.asList(aliases));
    }

    protected void addNetworkAlias(String alias) {
        this.networkAliases.add(alias);
    }

    protected void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    protected void setPrivilegedMode(boolean privilegedMode) {
        this.privilegedMode = privilegedMode;
    }

    public boolean isPrivilegedMode() {
        return this.privilegedMode;
    }

    public List<Bind> getBinds() {
        return new ArrayList<Bind>(this.binds);
    }

    protected void setBinds(List<Bind> binds) {
        this.binds.clear();
        this.binds.addAll(binds);
    }

    protected void addBinds(Bind ... binds) {
        this.binds.addAll(Arrays.asList(binds));
    }

    protected void addBind(Bind bind) {
        this.binds.add(bind);
    }

    protected void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }
}

