/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgRedirect;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitor;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitorRenderAsBashString;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgWord;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;
import org.aksw.shellgebra.algebra.cmd.transform.CmdOpTransformLib;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.algebra.cmd.transform.RedirectTargetVisitorToString;
import org.aksw.shellgebra.exec.CmdStrOps;

public class CmdOpVisitorToCmdString
implements CmdOpVisitor<CmdString> {
    protected CmdStrOps strOps;

    public static String toString(CmdOp cmdOp, CmdOpVisitor<CmdString> visitor) {
        CmdString c = cmdOp.accept(visitor);
        String result = c.isCmd() ? Arrays.asList(c.cmd()).stream().collect(Collectors.joining(" ")) : c.scriptString();
        return result;
    }

    public static String toArg(CmdString str) {
        String result = str.isScriptString() ? str.scriptString() : CmdOpVisitorToCmdString.toArg(str.cmd());
        return result;
    }

    public static String toArg(String[] cmd) {
        String result = Stream.of(cmd).collect(Collectors.joining(" "));
        return result;
    }

    public CmdOpVisitorToCmdString(CmdStrOps strOps) {
        this.strOps = Objects.requireNonNull(strOps);
    }

    @Override
    public CmdString visit(CmdOpExec op) {
        CmdString result;
        List<CmdArg> inArgs = op.args().args();
        CmdArgVisitorRenderAsBashString visitor = new CmdArgVisitorRenderAsBashString(this, this.strOps);
        ArrayList<String> outArgv = new ArrayList<String>(inArgs.size() + 1);
        outArgv.add(op.name());
        for (CmdArg inArg : inArgs) {
            String str = inArg.accept(visitor);
            outArgv.add(str);
        }
        if (op.prefixes().isEmpty()) {
            result = new CmdString((String[])outArgv.toArray(String[]::new));
        } else {
            StringBuilder sb = new StringBuilder();
            op.prefixes().forEach(e -> sb.append(e.key() + "=" + e.value()));
            sb.append(" ");
            sb.append(outArgv.stream().collect(Collectors.joining(" ")));
            result = new CmdString(sb.toString());
        }
        return result;
    }

    @Override
    public CmdString visit(CmdOpPipeline op) {
        List<String> args = op.getSubOps().stream().map(o -> o.accept(this)).map(CmdOpVisitorToCmdString::toArg).toList();
        CmdString result = new CmdString(this.strOps.pipeline(args));
        return result;
    }

    @Override
    public CmdString visit(CmdOpGroup op) {
        List<String> strs = CmdOpTransformLib.transformAll(this, op.subOps(), str -> CmdOpVisitorToCmdString.toArg(str));
        Object str2 = this.strOps.group(strs);
        for (CmdRedirect redirect : op.redirects()) {
            str2 = (String)str2 + " " + CmdRedirect.toString(this.strOps, redirect);
        }
        CmdString result = new CmdString((String)str2);
        return result;
    }

    @Override
    public CmdString visit(CmdOpVar op) {
        throw new UnsupportedOperationException("Variable encountered: " + String.valueOf(op));
    }

    public class CmdArgToString
    implements CmdArgVisitor<String> {
        @Override
        public String visit(CmdArgCmdOp arg) {
            String str = arg.cmdOp().accept(CmdOpVisitorToCmdString.this).scriptString();
            return CmdOpVisitorToCmdString.this.strOps.processSubstitution(str);
        }

        @Override
        public String visit(CmdArgRedirect arg) {
            RedirectTargetVisitorToString visitor = new RedirectTargetVisitorToString(CmdOpVisitorToCmdString.this.strOps);
            String str = arg.redirect().toString(visitor);
            return str;
        }

        @Override
        public String visit(CmdArgWord arg) {
            CmdArgVisitorRenderAsBashString visitor = new CmdArgVisitorRenderAsBashString(CmdOpVisitorToCmdString.this, CmdOpVisitorToCmdString.this.strOps);
            String str = arg.accept(visitor);
            return str;
        }
    }
}

