/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.docker;

import com.google.common.base.Converter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.aksw.commons.collections.ConvertingSet;
import org.aksw.commons.util.docker.Argv;
import org.aksw.commons.util.docker.ContainerUtils;
import org.aksw.shellgebra.exec.CmdStrOpsBash;
import org.aksw.shellgebra.exec.SysRuntimeCore;
import org.aksw.shellgebra.exec.SysRuntimeCoreDocker;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSites;
import org.aksw.shellgebra.introspect.LocatorCommand2;
import org.aksw.shellgebra.introspect.ShellCatalogEntry;
import org.aksw.shellgebra.introspect.ShellProbeResult;
import org.aksw.shellgebra.model.osreo.ImageIntrospector;
import org.aksw.vshell.registry.ExecSiteProbeResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;

public class ImageIntrospectorImpl
implements ImageIntrospector {
    private static final Logger logger = LoggerFactory.getLogger(ImageIntrospectorImpl.class);
    protected List<ShellCatalogEntry> shellCatalog;
    protected List<LocatorCommand2> locatorCatalog;
    protected Table<String, Argv, Boolean> imageToEntrypoints = HashBasedTable.create();
    protected ExecSiteProbeResults cmdAvailability;

    public static ImageIntrospector of() {
        List<ShellCatalogEntry> shellCatalog = ImageIntrospectorImpl.getShellCatalog();
        List<LocatorCommand2> locatorCatalog = ImageIntrospectorImpl.getLocatorCatalog();
        ExecSiteProbeResults execSiteProbeResults = ExecSiteProbeResults.get();
        return new ImageIntrospectorImpl(shellCatalog, locatorCatalog, execSiteProbeResults);
    }

    public ImageIntrospectorImpl(List<ShellCatalogEntry> shellCatalog, List<LocatorCommand2> locatorCatalog, ExecSiteProbeResults cmdAvailability) {
        this.shellCatalog = shellCatalog;
        this.locatorCatalog = locatorCatalog;
        this.cmdAvailability = cmdAvailability;
    }

    public Set<Argv> getKnownEntryPoints(String imageName) {
        Set a = this.imageToEntrypoints.row((Object)imageName).entrySet();
        Set b = Sets.filter(a, x -> Boolean.TRUE.equals(x.getValue()));
        ConvertingSet result = new ConvertingSet(b, Converter.from(Map.Entry::getKey, x -> Map.entry(x, true)));
        return result;
    }

    public static boolean canRunEntrypoint(String imageName, Argv ep, Table<String, Argv, Boolean> imageToEntrypoints, ExecSiteProbeResults cmdAvailability) {
        Boolean result = (Boolean)imageToEntrypoints.get((Object)imageName, (Object)ep);
        if (result == null) {
            try {
                result = ContainerUtils.canRunEntrypoint(imageName, ep.command(), ep.args());
            }
            catch (ContainerFetchException | ContainerLaunchException e) {
                result = false;
            }
            imageToEntrypoints.put((Object)imageName, (Object)ep, (Object)result);
            cmdAvailability.put(ep.command(), ExecSites.docker(imageName), (boolean)result);
        }
        return result;
    }

    public boolean hasCommandRaw(SysRuntimeCore sysRuntime, String command) throws InterruptedException, IOException {
        int exitCode = sysRuntime.runCmd(command);
        return exitCode != 127;
    }

    public boolean hasCommand(SysRuntimeCoreDocker sysRuntime, String command) {
        String imageName = sysRuntime.getImageRef();
        ExecSite execSite = ExecSites.docker(imageName);
        boolean result = this.hasCommand(sysRuntime, command, execSite);
        return result;
    }

    public boolean hasCommand(SysRuntimeCore sysRuntime, String command, ExecSite execSite) {
        Boolean result = this.cmdAvailability.get(command, execSite);
        if (result == null) {
            try {
                result = this.hasCommandRaw(sysRuntime, command);
                this.cmdAvailability.put(command, execSite, (boolean)result);
            }
            catch (ContainerFetchException | ContainerLaunchException e) {
                result = false;
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Deprecated
    public boolean hasCommand(String imageName, String shellLocation, List<String> commandOptions, String command) {
        ExecSite execSite = ExecSites.docker(imageName);
        Boolean result = this.cmdAvailability.get(command, execSite);
        if (result == null) {
            try {
                result = ContainerUtils.hasCommand(imageName, shellLocation, commandOptions, command);
                this.cmdAvailability.put(command, execSite, (boolean)result);
            }
            catch (ContainerFetchException | ContainerLaunchException e) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public ShellProbeResult findShell(SysRuntimeCoreDocker runtime, ShellCatalogEntry shell) {
        ShellProbeResult result;
        block4: {
            String imageName = runtime.getImageRef();
            String shellName = shell.name();
            logger.info("Probing image [{}] for shell [{}]", (Object)imageName, (Object)shellName);
            Collection<String> shellProbeLocations = shell.probeLocations();
            ShellProbeResult.ShellProbeResultBuilder builder = ShellProbeResult.newBuilder();
            result = null;
            builder.setCommandOption(shell.commandOption());
            Iterator<String> iterator = shellProbeLocations.iterator();
            if (!iterator.hasNext()) break block4;
            String shellLocation = iterator.next();
            builder.setLocation(shellLocation);
            String builtInLocator = shell.builtInLocator();
            if (builtInLocator != null) {
                builder.setLocatorCommand(builtInLocator);
            } else {
                for (LocatorCommand2 locatorCommand : this.locatorCatalog) {
                    for (String locatorLocation : locatorCommand.probeLocations()) {
                        boolean hasCommand = this.hasCommand(runtime, locatorLocation);
                        if (!hasCommand) continue;
                        builder.setLocatorCommand(locatorLocation);
                    }
                }
            }
            result = builder.build();
        }
        return result;
    }

    public static SysRuntimeCoreDocker findKeepAlive(String imageRef, boolean pullIfAbsent, List<ShellCatalogEntry> shellCatalog, Table<String, Argv, Boolean> imageToEntrypoints, ExecSiteProbeResults probeResults) {
        SysRuntimeCoreDocker result = null;
        List<Argv> keepAliveCatalog = ImageIntrospectorImpl.getKeepAliveCatalog();
        for (ShellCatalogEntry shellEntry : shellCatalog) {
            String shellProbeLocation;
            Argv entrypoint;
            boolean canRunEntrypoint;
            Iterator<String> iterator = shellEntry.probeLocations().iterator();
            while (iterator.hasNext() && (!(canRunEntrypoint = ImageIntrospectorImpl.canRunEntrypoint(imageRef, entrypoint = Argv.ofArgs(shellProbeLocation = iterator.next(), shellEntry.commandOption()), imageToEntrypoints, probeResults)) || (result = ImageIntrospectorImpl.startKeptAlive(imageRef, entrypoint, keepAliveCatalog, probeResults)) == null)) {
            }
        }
        return result;
    }

    public static SysRuntimeCoreDocker findKeepAlive(String imageRef, Argv entrypoint, ExecSiteProbeResults probeResults) {
        List<Argv> keepAliveCatalog = ImageIntrospectorImpl.getKeepAliveCatalog();
        SysRuntimeCoreDocker result = ImageIntrospectorImpl.startKeptAlive(imageRef, entrypoint, keepAliveCatalog, probeResults);
        return result;
    }

    private static Map.Entry<Argv, Argv> merge(Argv entrypoint, Argv command) {
        Argv actualEntryPoint = entrypoint;
        Argv actualCommand = command;
        if (entrypoint != null && entrypoint.isEmpty()) {
            actualEntryPoint = Argv.of(command.command());
            actualCommand = Argv.of(command.args());
        }
        return Map.entry(actualEntryPoint, actualCommand);
    }

    public static SysRuntimeCoreDocker startKeptAlive(String imageRef, List<Argv> candKeepAliveCmds, ExecSiteProbeResults probeResults) {
        ExecSite execSite = ExecSites.docker(imageRef);
        Exception last = null;
        SysRuntimeCoreDocker result = null;
        for (Argv keepAliveArgv : candKeepAliveCmds) {
            if (probeResults.isKnownUnavailable(keepAliveArgv, execSite)) continue;
            String actualEntryPoint = keepAliveArgv.command();
            String[] actualCmd = keepAliveArgv.argsToArray();
            try {
                GenericContainer c = new GenericContainer(imageRef);
                if (actualEntryPoint != null) {
                    c = c.withCreateContainerCmdModifier(x -> x.withEntrypoint(new String[]{actualEntryPoint}));
                }
                c = c.withCommand(actualCmd);
                c.start();
                Argv actualEntryPointArgv = Argv.of(actualEntryPoint);
                result = new SysRuntimeCoreDocker(c, actualEntryPointArgv, CmdStrOpsBash.get());
                probeResults.put(keepAliveArgv, execSite, true);
                break;
            }
            catch (Exception e) {
                probeResults.put(keepAliveArgv, execSite, false);
                last = e;
            }
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Could not find a portable keep-alive command (image may be distroless/scratch).", last);
    }

    @Deprecated
    public static SysRuntimeCoreDocker startKeptAlive(String imageRef, Argv entrypoint, List<Argv> candKeepAliveCmds, ExecSiteProbeResults probeResults) {
        ExecSite execSite = ExecSites.docker(imageRef);
        Exception last = null;
        SysRuntimeCoreDocker result = null;
        for (Argv keepAliveArgv : candKeepAliveCmds) {
            if (probeResults.isKnownUnavailable(keepAliveArgv, execSite)) continue;
            Map.Entry<Argv, Argv> entry = ImageIntrospectorImpl.merge(entrypoint, keepAliveArgv);
            Argv actualEntryPoint = entry.getKey();
            Argv actualCommand = entry.getValue();
            try {
                GenericContainer c = new GenericContainer(imageRef);
                if (actualEntryPoint != null) {
                    c = c.withCreateContainerCmdModifier(x -> x.withEntrypoint(actualEntryPoint.toArray()));
                }
                c = c.withCommand(actualCommand.toArray());
                c.start();
                result = new SysRuntimeCoreDocker(c, entrypoint, CmdStrOpsBash.get());
                probeResults.put(keepAliveArgv, execSite, true);
                break;
            }
            catch (Exception e) {
                probeResults.put(keepAliveArgv, execSite, false);
                last = e;
            }
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Could not find a portable keep-alive command (image may be distroless/scratch).", last);
    }

    public static List<Argv> getKeepAliveCatalog() {
        List<Argv> candidates = Arrays.asList({"sleep", "365d"}, {"/bin/sleep", "365d"}, {"/usr/bin/sleep", "365d"}, {"sleep", "infinity"}, {"/bin/sleep", "infinity"}, {"/usr/bin/sleep", "infinity"}, {"tail", "-f", "/dev/null"}, {"/bin/tail", "-f", "/dev/null"}, {"/usr/bin/tail", "-f", "/dev/null"}, {"/bin/busybox", "sleep", "365d"}, {"/usr/bin/busybox", "sleep", "365d"}, {"sh", "-c", "while :; do sleep 1h; done"}, {"/bin/sh", "-c", "while :; do sleep 1h; done"}, {"/usr/bin/sh", "-c", "while :; do sleep 1h; done"}).stream().map(Argv::of).toList();
        return candidates;
    }

    public static List<ShellCatalogEntry> getShellSubCatalog(List<ShellCatalogEntry> catalog, String shellName) {
        List<ShellCatalogEntry> result = catalog.stream().filter(entry -> Objects.equals(entry.name(), shellName)).toList();
        return result;
    }

    public static List<ShellCatalogEntry> getShellCatalog() {
        List<ShellCatalogEntry> result = Arrays.asList(new ShellCatalogEntry("bash", List.of("/bin/bash", "/usr/bin/bash"), "-c", null));
        return result;
    }

    public static List<LocatorCommand2> getLocatorCatalog() {
        List<LocatorCommand2> result = List.of(new LocatorCommand2("which", List.of("/bin/which", "/usr/bin/which")));
        return result;
    }
}

