/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Volume;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.aksw.commons.util.docker.ContainerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public class ContainerPathResolver {
    private static final Logger logger = LoggerFactory.getLogger(ContainerPathResolver.class);
    private final Map<Path, Path> containerToHostPaths = new LinkedHashMap<Path, Path>();

    private ContainerPathResolver(Map<Path, Path> mountMap) {
        this.containerToHostPaths.putAll(mountMap);
    }

    public Path resolveOrNull(Path containerPath) {
        Path result = null;
        for (Map.Entry<Path, Path> entry : this.containerToHostPaths.entrySet()) {
            Path prefix = entry.getKey();
            if (!containerPath.startsWith(prefix)) continue;
            Path relative = prefix.relativize(containerPath);
            result = entry.getValue().resolve(relative);
            break;
        }
        return result;
    }

    public static Path expectResolvePath(ContainerPathResolver containerPathResolver, Path path) {
        Path result = ContainerPathResolver.resolvePath(containerPathResolver, path, true);
        return result;
    }

    public static String resolvePathString(ContainerPathResolver containerPathResolver, String inPathStr) {
        Path inPath;
        Path outPathOrNull;
        String result = inPathStr;
        if (containerPathResolver != null && (outPathOrNull = containerPathResolver.resolveOrNull(inPath = Path.of(inPathStr, new String[0]))) != null) {
            result = outPathOrNull.toString();
        }
        return result;
    }

    public static Path resolvePath(ContainerPathResolver containerPathResolver, Path path) {
        Path result = ContainerPathResolver.resolvePath(containerPathResolver, path, false);
        return result;
    }

    public static Path resolvePath(ContainerPathResolver containerPathResolver, Path path, boolean expectedToResolve) {
        Objects.requireNonNull(path);
        Path result = null;
        if (containerPathResolver != null) {
            result = containerPathResolver.resolveOrNull(path);
            if (result == null && expectedToResolve) {
                logger.warn("Container path unexpectedly not mapped to a host path: " + String.valueOf(path));
                logger.warn("This will likely cause follow-up problems.");
            } else {
                logger.info("Container path -> Host path: " + String.valueOf(path) + " -> " + String.valueOf(result));
            }
        }
        if (result == null) {
            result = path;
        }
        return result;
    }

    public static ContainerPathResolver create() {
        ContainerPathResolver result = null;
        try {
            DockerClient dockerClient = DockerClientFactory.instance().client();
            InspectContainerResponse inspection = ContainerUtils.detectContainer(dockerClient);
            if (inspection != null) {
                result = ContainerPathResolver.create(inspection);
            }
        }
        catch (Exception e) {
            logger.info("Did not detect docker deamon.", (Throwable)e);
        }
        return result;
    }

    public static Map<Path, Path> getMountMap(InspectContainerResponse containerInfo) {
        Objects.requireNonNull(containerInfo);
        LinkedHashMap<Path, Path> mountMap = new LinkedHashMap<Path, Path>();
        for (InspectContainerResponse.Mount mount : containerInfo.getMounts()) {
            String source = mount.getSource();
            Volume destination = mount.getDestination();
            if (source == null || !source.startsWith("/")) continue;
            String destPath = destination.getPath();
            Path containerPath = Paths.get(destPath, new String[0]);
            Path hostPath = Paths.get(source, new String[0]);
            mountMap.put(containerPath, hostPath);
        }
        return mountMap;
    }

    public static ContainerPathResolver create(InspectContainerResponse containerInfo) {
        Map<Path, Path> mountMap = ContainerPathResolver.getMountMap(containerInfo);
        logger.info("Mount map: " + String.valueOf(mountMap));
        return new ContainerPathResolver(mountMap);
    }
}

