package org.aksw.shellgebra.exec.stage;

import java.nio.file.Path;
import java.util.Objects;

import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.aksw.shellgebra.util.PathLifeCycles;

import com.google.common.io.ByteSource;

public class BoundStageByteSource
    implements BoundStage
{
    private ByteSource byteSource;

    public BoundStageByteSource(ByteSource byteSource) {
        super();
        this.byteSource = Objects.requireNonNull(byteSource);
    }

    @Override
    public ByteSource toByteSource() {
        return byteSource;
    }

    @Override
    public FileWriterTask execToRegularFile(Path hostPath) {
        ByteSource bs = toByteSource();
        return new FileWriterTaskFromByteSource(hostPath, PathLifeCycles.none(), bs);
    }

    @Override
    public FileWriterTask execToFile(Path hostPath, PathLifeCycle pathLifeCycle) {
        ByteSource bs = toByteSource();
        return new FileWriterTaskFromByteSource(hostPath, PathLifeCycles.none(), bs);
    }

    @Override
    public FileWriterTask runToHostPipe() {
        ByteSource bs = toByteSource();
        PathLifeCycle pathLifeCycle = PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe());
        Path tempFile = FileMapper.allocateTempPath("", "");
        return new FileWriterTaskFromByteSource(tempFile, pathLifeCycle, bs);
    }
}
