/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.aksw.vshell.registry.DynamicOutput;
import org.aksw.vshell.registry.OutputBase;

public class FileOutput
extends OutputBase
implements DynamicOutput {
    private Path path;

    protected FileOutput(Path path, OutputStream outputStream) {
        super(outputStream);
        this.path = path;
    }

    @Override
    public boolean hasFile() {
        return true;
    }

    @Override
    public Path getFile() {
        return this.path;
    }

    @Override
    protected OutputStream openOutputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    public static FileOutput of(Path path, OutputStream outputStream) {
        return new FileOutput(path, outputStream);
    }

    public static FileOutput of(Path path) {
        return FileOutput.of(path, null);
    }

    public static FileOutput of(File file) {
        return FileOutput.of(file.toPath());
    }

    public Path getPath() {
        return this.path;
    }
}

