/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutorService;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.op.placed.PlacedCmdOp;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentHost;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentJvm;
import org.aksw.shellgebra.exec.model.ExecSiteDockerImage;
import org.aksw.shellgebra.exec.model.ExecSiteVisitor;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.vshell.registry.CmdOpVisitorToBase;
import org.aksw.vshell.registry.CmdOpVisitorToPbDocker;
import org.aksw.vshell.registry.CmdOpVisitorToPbHost;
import org.aksw.vshell.registry.CmdOpVisitorToPbJvm;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.FinalPlacement;

public class ExecSiteToProcessDispatcher
implements ExecSiteVisitor<CmdOpVisitorToBase> {
    private FinalPlacement finalPlacement;
    private CommandCatalog commandCatalog;
    private FileMapper fileMapper;
    private ExecutorService executorService;
    private ProcessRunner context;
    private CmdOpVisitorToPbJvm jvmVisitor;
    private CmdOpVisitorToPbHost hostVisitor;
    private Deque<Process> closeables = new ArrayDeque<Process>();

    public ExecSiteToProcessDispatcher(FinalPlacement finalPlacement, ProcessRunner context, CommandCatalog commandCatalog, FileMapper fileMapper, ExecutorService executorService) {
        this.fileMapper = fileMapper;
        this.context = context;
        this.commandCatalog = commandCatalog;
        this.finalPlacement = finalPlacement;
        this.executorService = executorService;
        this.jvmVisitor = new CmdOpVisitorToPbJvm(this);
        this.hostVisitor = new CmdOpVisitorToPbHost(this);
    }

    public void addProcess(Process closeable) {
        this.closeables.add(closeable);
    }

    public Deque<Process> getProcesses() {
        return this.closeables;
    }

    public ProcessRunner getContext() {
        return this.context;
    }

    public FileMapper getFileMapper() {
        return this.fileMapper;
    }

    public CommandCatalog getCommandCatalog() {
        return this.commandCatalog;
    }

    @Override
    public CmdOpVisitorToBase visit(ExecSiteDockerImage execSite) {
        return new CmdOpVisitorToPbDocker(this, execSite);
    }

    @Override
    public CmdOpVisitorToBase visit(ExecSiteCurrentHost execSite) {
        return this.hostVisitor;
    }

    @Override
    public CmdOpVisitorToBase visit(ExecSiteCurrentJvm execSite) {
        return this.jvmVisitor;
    }

    public IProcessBuilderCore<?> resolve(CmdOpVar v) {
        PlacedCmdOp.PlacedCmd placedCmd = this.finalPlacement.placements().get(v);
        IProcessBuilderCore<?> result = this.resolve(placedCmd);
        return result;
    }

    public IProcessBuilderCore<?> resolve(PlacedCmdOp.PlacedCmd placedCmd) {
        ExecSite execSite = placedCmd.execSite();
        CmdOp cmdOp = placedCmd.cmdOp();
        CmdOpVisitor visitor = execSite.accept(this);
        IProcessBuilderCore result = (IProcessBuilderCore)cmdOp.accept(visitor);
        return result;
    }
}

