/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransform;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransformBase;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransformer;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSites;
import org.aksw.shellgebra.exec.model.PlacedCommand;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.CommandRegistry;
import org.aksw.vshell.registry.ExecSiteResolver;

public class CmdOpVisitorCandidatePlacer
implements CmdOpVisitor<PlacedCommand> {
    private CommandCatalog cmdRegistry;
    private ExecSiteResolver execSiteResolver;
    private Set<ExecSite> preferredExecSites;
    private Map<CmdOp, Set<ExecSite>> opToSites = new IdentityHashMap<CmdOp, Set<ExecSite>>();
    private Map<CmdOpVar, PlacedCommand> varToPlacement = new HashMap<CmdOpVar, PlacedCommand>();
    private CommandRegistry probeResultsCatalog;
    private int nextVar = 0;

    public CmdOpVisitorCandidatePlacer(CommandCatalog cmdRegistry, CommandRegistry probeResultsCatalog, ExecSiteResolver execSiteResolver, Set<ExecSite> preferredExecSites) {
        this.cmdRegistry = cmdRegistry;
        this.probeResultsCatalog = probeResultsCatalog;
        this.execSiteResolver = execSiteResolver;
        this.preferredExecSites = preferredExecSites;
    }

    public Map<CmdOpVar, PlacedCommand> getVarToPlacement() {
        return this.varToPlacement;
    }

    @Override
    public PlacedCommand visit(CmdOpExec origOp) {
        ArgumentList newArgs = CmdArgTransformer.transform(origOp.args(), (CmdArgTransform)new CmdArgTransformBase(){

            @Override
            public CmdArg transform(CmdArgCmdOp arg, CmdOp subOp) {
                PlacedCommand pc = subOp.accept(CmdOpVisitorCandidatePlacer.this);
                CmdOpVar subOpVar = new CmdOpVar("v" + CmdOpVisitorCandidatePlacer.this.nextVar++);
                CmdOpVisitorCandidatePlacer.this.varToPlacement.put(subOpVar, pc);
                return CmdArg.ofProcessSubstution(subOpVar);
            }
        }, null, null);
        CmdOpExec op = new CmdOpExec(origOp.prefixes(), origOp.name(), newArgs);
        Set execSites = this.opToSites.computeIfAbsent(op, k -> new HashSet());
        String virtCmdName = op.getName();
        Multimap<ExecSite, String> candResolutions = this.cmdRegistry.get(virtCmdName);
        LinkedHashSet candCmdLocations = new LinkedHashSet(candResolutions.values());
        for (ExecSite execSite : this.preferredExecSites) {
            for (String cmdLocation : candCmdLocations) {
                boolean isCmdPresent = this.execSiteResolver.providesCommand(cmdLocation, execSite);
                if (!isCmdPresent) continue;
                execSites.add(execSite);
                this.probeResultsCatalog.put(virtCmdName, execSite, cmdLocation);
            }
        }
        System.out.println("Placement: " + String.valueOf(op) + ": " + String.valueOf(execSites));
        if (execSites.isEmpty()) {
            Map<ExecSite, String> resolutions = this.execSiteResolver.resolve(virtCmdName);
            execSites.addAll(resolutions.keySet());
        }
        if (execSites.isEmpty()) {
            throw new RuntimeException("No exec sites found for: " + virtCmdName);
        }
        boolean checkPresenceInImages = true;
        this.opToSites.put(op, execSites);
        return new PlacedCommand(op, execSites);
    }

    @Override
    public PlacedCommand visit(CmdOpPipeline op) {
        List<CmdOp> subOps = op.subOps();
        PlacedCommand result = this.process(subOps, CmdOpPipeline::new);
        return result;
    }

    @Override
    public PlacedCommand visit(CmdOpGroup op) {
        List<CmdOp> subOps = op.subOps();
        PlacedCommand result = this.process(subOps, CmdOpGroup::new);
        return result;
    }

    @Override
    public PlacedCommand visit(CmdOpVar op) {
        throw new RuntimeException("var resolution not supported.");
    }

    protected PlacedCommand process(List<CmdOp> subOps, Function<List<CmdOp>, CmdOp> ctor) {
        PlacedCommand result;
        int i;
        ArrayList<PlacedCommand> placements = new ArrayList<PlacedCommand>(subOps.size());
        for (CmdOp subOp : subOps) {
            PlacedCommand contrib = subOp.accept(this);
            if (contrib == null) {
                throw new RuntimeException("Null returned as placement for: " + String.valueOf(subOp));
            }
            if (contrib.execSites().isEmpty()) {
                throw new IllegalStateException("Empty set of exec sites returned for: " + String.valueOf(subOp));
            }
            placements.add(contrib);
        }
        Sets.SetView currentSet = null;
        ArrayList<PlacedCommand> childStreaks = new ArrayList<PlacedCommand>(subOps.size());
        int currentStreakOffset = 0;
        int n = placements.size();
        for (i = 0; i < n; ++i) {
            Sets.SetView nextSet;
            Sets.SetView rawContrib;
            PlacedCommand pc = (PlacedCommand)placements.get(i);
            Sets.SetView compatContrib = rawContrib = pc.execSites();
            if (currentSet != null) {
                compatContrib = new LinkedHashSet<ExecSite>();
                for (ExecSite c : rawContrib) {
                    boolean canRunPipeline = this.execSiteResolver.canRunPipeline(c);
                    if (!canRunPipeline) continue;
                    compatContrib.add(c);
                }
            }
            Sets.SetView setView = nextSet = currentSet == null ? rawContrib : Sets.intersection(compatContrib, currentSet);
            if (nextSet.isEmpty()) {
                List currentStreak = placements.subList(currentStreakOffset, i);
                PlacedCommand placed = this.doPlacement(ctor, this.preferredExecSites, (Set<ExecSite>)currentSet, currentStreak);
                childStreaks.add(placed);
                currentSet = rawContrib;
                currentStreakOffset = i;
                continue;
            }
            currentSet = nextSet;
        }
        if (currentSet != null) {
            List<PlacedCommand> currentStreak = placements.subList(currentStreakOffset, i);
            PlacedCommand placed = this.doPlacement(ctor, this.preferredExecSites, (Set<ExecSite>)currentSet, currentStreak);
            childStreaks.add(placed);
        }
        if (childStreaks.size() == 1) {
            result = (PlacedCommand)childStreaks.get(0);
        } else {
            LinkedHashSet<ExecSite> parentExecSites = new LinkedHashSet<ExecSite>();
            Set childExecSites = childStreaks.stream().map(PlacedCommand::execSites).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            for (Object childExecSite : childExecSites) {
                if (!this.execSiteResolver.canRunPipeline((ExecSite)childExecSite)) continue;
                parentExecSites.add((ExecSite)childExecSite);
                break;
            }
            if (parentExecSites.isEmpty()) {
                parentExecSites.add(ExecSites.host());
            }
            ArrayList<CmdOpVar> newSubOps = new ArrayList<CmdOpVar>(childStreaks.size());
            for (PlacedCommand childStreak : childStreaks) {
                CmdOpVar cmdOpVar = new CmdOpVar("v" + this.nextVar++);
                newSubOps.add(cmdOpVar);
                this.varToPlacement.put(cmdOpVar, childStreak);
            }
            CmdOp newCmdOp = ctor.apply(newSubOps);
            result = new PlacedCommand(newCmdOp, parentExecSites);
        }
        return result;
    }

    protected PlacedCommand doPlacement(Function<List<CmdOp>, CmdOp> ctor, Set<ExecSite> preferredExecSites, Set<ExecSite> candidateExecSites, List<PlacedCommand> streak) {
        List<CmdOp> placedSubOps;
        if (candidateExecSites.isEmpty()) {
            throw new IllegalArgumentException("Candidate exec site set must not be empty.");
        }
        Object effectiveExecSites = Sets.intersection(preferredExecSites, candidateExecSites);
        if (effectiveExecSites.isEmpty()) {
            effectiveExecSites = candidateExecSites;
        }
        CmdOp part = (placedSubOps = streak.stream().map(PlacedCommand::cmdOp).toList()).size() == 1 ? placedSubOps.get(0) : ctor.apply(placedSubOps);
        PlacedCommand placed = new PlacedCommand(part, (Set<ExecSite>)effectiveExecSites);
        return placed;
    }
}

