/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgRedirect;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitor;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgWord;
import org.aksw.shellgebra.algebra.cmd.arg.Token;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;
import org.aksw.shellgebra.algebra.cmd.op.RedirectTarget;
import org.aksw.shellgebra.algebra.cmd.op.RedirectTargetVisitor;
import org.aksw.shellgebra.exec.graph.JRedirect;
import org.aksw.shellgebra.io.pipe.NamedPipe;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.vshell.registry.CmdOpVisitorToBase;
import org.aksw.vshell.registry.ExecSiteToProcessDispatcher;
import org.aksw.vshell.registry.ProcessOverThread;

public class CmdArgTransformToProcess
implements CmdArgVisitor<CmdArg>,
Token.TokenVisitor<Token> {
    private CmdOpVisitor<IProcessBuilderCore<?>> cmdOpVisitor;
    private ExecSiteToProcessDispatcher dispatcher;

    public CmdArgTransformToProcess(CmdOpVisitorToBase cmdOpVisitor) {
        this.cmdOpVisitor = cmdOpVisitor;
        this.dispatcher = cmdOpVisitor.getDispatcher();
    }

    public static <T> List<T> transformArgs(Token.TokenVisitor<T> visitor, List<Token> tokens) {
        return tokens.stream().map(token -> CmdArgTransformToProcess.transform(visitor, token)).toList();
    }

    public static <T> T transform(Token.TokenVisitor<T> visitor, Token token) {
        T result = token.accept(visitor);
        return result;
    }

    @Override
    public CmdArg visit(CmdArgRedirect arg) {
        CmdRedirect redirect = arg.redirect();
        RedirectTarget target = redirect.target();
        RedirectTarget newTarget = target.accept(new RedirectTargetVisitor<RedirectTarget.RedirectTargetFile>(){

            @Override
            public RedirectTarget.RedirectTargetFile visit(RedirectTarget.RedirectTargetProcessSubstitution re) {
                CmdOp cmdOp = re.cmdOp();
                Path path = CmdArgTransformToProcess.this.processToPipe(cmdOp);
                return new RedirectTarget.RedirectTargetFile(path.toString());
            }

            @Override
            public RedirectTarget.RedirectTargetFile visit(RedirectTarget.RedirectTargetFile redirect) {
                return redirect;
            }
        });
        return new CmdArgRedirect(new CmdRedirect(redirect.fd(), redirect.openMode(), newTarget));
    }

    public Path processVarToPipe(CmdOpVar cmdOp) {
        IProcessBuilderCore<?> processBuilder = this.dispatcher.resolve(cmdOp);
        return this.processToPipe(processBuilder);
    }

    public Path processToPipe(CmdOp cmdOp) {
        IProcessBuilderCore<?> processBuilder = cmdOp.accept(this.cmdOpVisitor);
        return this.processToPipe(processBuilder);
    }

    public Path processToPipe(IProcessBuilderCore<?> processBuilder) {
        Path pipe;
        try {
            pipe = NamedPipe.create();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        processBuilder.redirectOutput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.to(pipe.toFile())));
        Process process = ProcessOverThread.startInThread(processBuilder, this.dispatcher.getContext());
        this.dispatcher.addProcess(process);
        return pipe;
    }

    @Override
    public CmdArg visit(CmdArgWord arg) {
        return new CmdArgWord(arg.escapeType(), arg.tokens().stream().map(token -> token.accept(this)).toList());
    }

    @Override
    public Token visit(Token.TokenLiteral token) {
        return token;
    }

    @Override
    public Token visit(Token.TokenPath token) {
        return token;
    }

    @Override
    public Token visit(Token.TokenVar token) {
        CmdOpVar cv = new CmdOpVar(token.name());
        Path path = this.processToPipe(cv);
        return new Token.TokenPath(path.toString());
    }

    @Override
    public Token visit(Token.TokenCmdOp token) {
        CmdOp cmdOp = token.cmdOp();
        Path path = this.processToPipe(cmdOp);
        return new Token.TokenPath(path.toString());
    }

    @Override
    public CmdArg visit(CmdArgCmdOp arg) {
        CmdOp cmdOp = arg.cmdOp();
        Path path = this.processToPipe(cmdOp);
        return CmdArg.ofPathString(path.toString());
    }
}

