/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.aksw.shellgebra.util.PathLifeCycle;

public class PathLifeCycles {
    private static final PathLifeCycle NONE = new PathLifeCycle(){};

    public static PathLifeCycle none() {
        return NONE;
    }

    public static PathLifeCycle namedPipe() {
        return new PathLifeCycleForNamedPipe();
    }

    public static PathLifeCycle deleteAfterExec(PathLifeCycle delegate) {
        PathLifeCycle result = delegate instanceof PathLifeCycleDeleteAfterExec ? delegate : new PathLifeCycleDeleteAfterExec(delegate);
        return result;
    }

    public static class PathLifeCycleForNamedPipe
    implements PathLifeCycle {
        @Override
        public void beforeExec(Path path) throws IOException {
            SysRuntimeImpl.forCurrentOs().createNamedPipe(path);
        }

        public String toString() {
            return "namedPipe";
        }
    }

    public static class PathLifeCycleDeleteAfterExec
    extends PathLifeCycleWrapperBase {
        public PathLifeCycleDeleteAfterExec(PathLifeCycle delegate) {
            super(delegate);
        }

        @Override
        public void afterExec(Path path) throws IOException {
            Files.deleteIfExists(path);
        }

        public String toString() {
            return "deleteAfterExec/" + String.valueOf(this.getDelegate());
        }
    }

    public static class PathLifeCycleWrapperBase
    implements PathLifeCycleWrapper {
        protected PathLifeCycle delegate;

        public PathLifeCycleWrapperBase(PathLifeCycle delegate) {
            this.delegate = delegate;
        }

        @Override
        public PathLifeCycle getDelegate() {
            return this.delegate;
        }
    }

    public static interface PathLifeCycleWrapper
    extends PathLifeCycle {
        public PathLifeCycle getDelegate();

        @Override
        default public void beforeExec(Path item) throws IOException {
            this.getDelegate().beforeExec(item);
        }

        @Override
        default public void afterExec(Path item) throws IOException {
            this.getDelegate().afterExec(item);
        }
    }
}

