/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.picocli;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.aksw.shellgebra.shim.core.ArgsParser;
import picocli.CommandLine;

public class ArgsParserPicocli<T>
implements ArgsParser<T> {
    private final Supplier<T> modelSupplier;

    public ArgsParserPicocli(Supplier<T> modelSupplier) {
        this.modelSupplier = modelSupplier;
    }

    @Override
    public T parse(String[] args) {
        T model = this.modelSupplier.get();
        CommandLine cmd = new CommandLine(model);
        cmd.parseArgs(args);
        return model;
    }

    public static <T> ArgsParser<T> of(Class<T> clazz) {
        return new ArgsParserPicocli<T>(ArgsParserPicocli.asInstanceSupplier(clazz));
    }

    public static <T> ArgsParser<T> of(Supplier<T> instanceCreator) {
        return new ArgsParserPicocli<T>(instanceCreator);
    }

    private static <T> Supplier<T> asInstanceSupplier(Class<T> clazz) {
        Constructor<T> ctor;
        try {
            ctor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return ArgsParserPicocli.asInstanceSupplier(ctor);
    }

    private static <T> Supplier<T> asInstanceSupplier(Constructor<T> ctor) {
        return () -> ArgsParserPicocli.newInstance(ctor);
    }

    private static <T> T newInstance(Constructor<T> ctor) {
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

