/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.registry.tool;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.aksw.shellgebra.registry.tool.model.CommandTargetInfo;

public class CommandTargetInfoImpl
implements CommandTargetInfo {
    protected String command;
    protected Optional<Boolean> availableOnHost;
    protected Map<String, Boolean> imageToAvailability;

    public CommandTargetInfoImpl(String command) {
        this(command, Optional.of(Boolean.TRUE), new LinkedHashMap<String, Boolean>());
    }

    private CommandTargetInfoImpl(String command, Optional<Boolean> availableOnHost, Map<String, Boolean> dockerImages) {
        this.command = command;
        this.availableOnHost = availableOnHost;
        this.imageToAvailability = dockerImages;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public CommandTargetInfoImpl setAvailabilityHost(Boolean availableOnHost) {
        this.availableOnHost = Optional.ofNullable(availableOnHost);
        return this;
    }

    @Override
    public Optional<Boolean> getAvailableOnHost() {
        return this.availableOnHost;
    }

    @Override
    public Stream<String> getDockerImages() {
        return this.imageToAvailability.keySet().stream();
    }

    @Override
    public Stream<String> getAvailableImages() {
        return this.imageToAvailability.entrySet().stream().filter(e -> Boolean.TRUE.equals(e.getValue())).map(Map.Entry::getKey);
    }

    public CommandTargetInfoImpl setDockerImageAvailability(String imageName, Boolean value) {
        this.imageToAvailability.put(imageName, value);
        return this;
    }

    public CommandTargetInfoImpl addAvailabilityDockerImage(String imageName) {
        this.setDockerImageAvailability(imageName, true);
        return this;
    }

    @Override
    public Optional<Boolean> getDockerImageAvailability(String imageName) {
        return Optional.ofNullable(this.imageToAvailability.get(imageName));
    }

    public CommandTargetInfoImpl clone() {
        return new CommandTargetInfoImpl(this.command, this.availableOnHost, new LinkedHashMap<String, Boolean>(this.imageToAvailability));
    }

    public String toString() {
        return "CommandPathInfo [command=" + this.command + ", availableOnHost=" + String.valueOf(this.availableOnHost) + ", dockerImages=" + String.valueOf(this.imageToAvailability) + "]";
    }
}

