/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.aksw.shellgebra.exec.graph.PathResource;

public class ProcessPipeline
extends Process {
    private List<Process> processes;
    private List<PathResource> pipes;
    private CompletableFuture<?> future;

    public ProcessPipeline(List<Process> processes, List<PathResource> pipes) {
        this.processes = processes;
        this.pipes = pipes;
        List<CompletableFuture> futures = processes.stream().map(Process::onExit).toList();
        this.future = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).whenComplete((x, e) -> {
            for (PathResource pipe : this.pipes) {
                try {
                    pipe.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public InputStream getErrorStream() {
        return null;
    }

    @Override
    public int waitFor() throws InterruptedException {
        try {
            this.future.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return this.processes.get(this.processes.size() - 1).exitValue();
    }

    @Override
    public int exitValue() {
        return this.processes.get(this.processes.size() - 1).exitValue();
    }

    @Override
    public void destroy() {
        this.processes.forEach(Process::destroy);
    }
}

