/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.testcontainers.containers.Container;

public class ProcessDockerExecResult
extends Process {
    private Container.ExecResult execResult;
    private OutputStream stdin;
    private InputStreamWrapper stdout;
    private InputStreamWrapper stderr;
    private Object lock = new Object();

    public ProcessDockerExecResult(Container.ExecResult execResult) {
        this.execResult = execResult;
        this.stdin = OutputStream.nullOutputStream();
        this.stdout = new InputStreamWrapper(new ByteArrayInputStream(execResult.getStdout().getBytes(StandardCharsets.UTF_8)));
        this.stderr = new InputStreamWrapper(new ByteArrayInputStream(execResult.getStderr().getBytes(StandardCharsets.UTF_8)));
    }

    public Container.ExecResult getExecResult() {
        return this.execResult;
    }

    private boolean isAllConsumed() {
        boolean result = this.stdout.isConsumed() && this.stderr.isConsumed();
        return result;
    }

    private void closeAll() {
        IOUtils.closeQuietly((OutputStream)this.stdin);
        IOUtils.closeQuietly((InputStream)((Object)this.stdout));
        IOUtils.closeQuietly((InputStream)((Object)this.stderr));
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public int waitFor() throws InterruptedException {
        return 0;
    }

    @Override
    public int exitValue() {
        int exitValue = this.execResult.getExitCode();
        return exitValue;
    }

    @Override
    public void destroy() {
        this.closeAll();
    }

    private class InputStreamWrapper
    extends ProxyInputStream {
        private boolean isConsumed;

        public InputStreamWrapper(InputStream proxy) {
            super(proxy);
            this.isConsumed = false;
        }

        public boolean isConsumed() {
            return this.isConsumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void afterRead(int n) throws IOException {
            super.afterRead(n);
            if (-1 == n && !this.isConsumed) {
                Object object = ProcessDockerExecResult.this.lock;
                synchronized (object) {
                    if (!this.isConsumed) {
                        this.isConsumed = true;
                        if (ProcessDockerExecResult.this.isAllConsumed()) {
                            ProcessDockerExecResult.this.closeAll();
                        }
                    }
                }
            }
        }
    }
}

