/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import com.github.dockerjava.api.model.Bind;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.aksw.commons.util.docker.ContainerPathResolver;
import org.aksw.commons.util.docker.ContainerUtils;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgWord;
import org.aksw.shellgebra.algebra.cmd.arg.Token;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOps;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.CmdOpRewriter;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.SysRuntimeCoreLazy;
import org.aksw.shellgebra.exec.SysRuntimeFactoryDocker;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.aksw.shellgebra.exec.graph.JRedirect;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.exec.invocation.CompileContext;
import org.aksw.shellgebra.exec.invocation.ExecutableInvocation;
import org.aksw.shellgebra.exec.invocation.Invocation;
import org.aksw.shellgebra.exec.invocation.InvocationCompiler;
import org.aksw.shellgebra.exec.invocation.InvocationCompilerImpl;
import org.aksw.shellgebra.exec.invocation.InvokableProcessBuilderBase;
import org.aksw.shellgebra.io.pipe.NamedPipe;
import org.aksw.shellgebra.io.pipe.PosixPipe;
import org.aksw.shellgebra.processbuilder.PathAndProcess;
import org.aksw.shellgebra.processbuilder.ProcessOverDockerContainer;
import org.aksw.shellgebra.shim.core.Args;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.shellgebra.shim.core.JvmCommandParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class ProcessBuilderDocker
extends InvokableProcessBuilderBase<ProcessBuilderDocker> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessBuilderDocker.class);
    protected String imageRef;
    protected String entrypoint;
    protected String workingDirectory;
    protected ContainerPathResolver containerPathResolver;
    protected FileMapper fileMapper;
    protected Boolean interactive;
    protected InvocationCompiler compiler;
    protected JvmCommandParser commandParser;

    @Override
    public boolean supportsAnonPipeRead() {
        return false;
    }

    @Override
    public boolean supportsAnonPipeWrite() {
        return false;
    }

    @Override
    public boolean supportsDirectNamedPipe() {
        return true;
    }

    protected Optional<Args> tryParseArgs() {
        Invocation inv = this.invocation();
        if (inv == null) {
            throw new IllegalStateException("No invocation set");
        }
        List<String> argv = inv.asArgv().argv();
        List<String> args = argv.subList(1, argv.size());
        Optional<Boolean> baseInteractive = Optional.ofNullable(this.interactive);
        Args ar = null;
        if (this.commandParser != null) {
            ar = this.commandParser.parseArgs((String[])args.toArray(String[]::new));
        }
        return Optional.ofNullable(ar);
    }

    @Override
    public boolean accessesStdIn() {
        Args ar = this.tryParseArgs().orElse(null);
        boolean result = this.deriveInteractive(ar);
        return result;
    }

    protected boolean deriveInteractive(Args ar) {
        Optional<Boolean> baseInteractive = Optional.ofNullable(this.interactive);
        boolean actualInteractive = this.commandParser != null ? baseInteractive.or(ar::readsStdin).orElse(true).booleanValue() : baseInteractive.orElse(true).booleanValue();
        return actualInteractive;
    }

    public static ProcessBuilderDocker of(String ... command) {
        return (ProcessBuilderDocker)new ProcessBuilderDocker().command(command);
    }

    public static ProcessBuilderDocker of(List<String> command) {
        return (ProcessBuilderDocker)new ProcessBuilderDocker().command(command);
    }

    public String imageRef() {
        return this.imageRef;
    }

    public ProcessBuilderDocker imageRef(String imageRef) {
        this.imageRef = imageRef;
        return (ProcessBuilderDocker)this.self();
    }

    public ProcessBuilderDocker interactive(Boolean interactive) {
        this.interactive = interactive;
        return (ProcessBuilderDocker)this.self();
    }

    public Boolean interactive() {
        return this.interactive;
    }

    public ProcessBuilderDocker commandParser(JvmCommandParser commandParser) {
        this.commandParser = commandParser;
        return (ProcessBuilderDocker)this.self();
    }

    public JvmCommandParser jvmCommandParser() {
        return this.commandParser;
    }

    public FileMapper fileMapper() {
        return this.fileMapper;
    }

    public ProcessBuilderDocker fileMapper(FileMapper fileMapper) {
        this.fileMapper = fileMapper;
        return (ProcessBuilderDocker)this.self();
    }

    public String workingDirectory() {
        return this.workingDirectory;
    }

    public ProcessBuilderDocker workingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
        return (ProcessBuilderDocker)this.self();
    }

    public ProcessBuilderDocker compiler(InvocationCompiler compiler) {
        this.compiler = compiler;
        return (ProcessBuilderDocker)this.self();
    }

    public InvocationCompiler compiler() {
        return this.compiler;
    }

    @Override
    public Process start(ProcessRunner executor) throws IOException {
        Objects.requireNonNull(this.imageRef, "image not set.");
        Invocation inv = this.invocation();
        if (inv == null) {
            throw new IllegalStateException("No invocation set");
        }
        PathAndProcess outProcess = this.processOutput(executor.outputPipe(), this.redirectOutput());
        PathAndProcess errProcess = this.processOutput(executor.errorPipe(), this.redirectError());
        Path hostMountableOutputPath = outProcess.path();
        Path hostMountableErrorPath = errProcess.path();
        FileMapper finalFileMapper = this.fileMapper.clone();
        Args ar = this.tryParseArgs().orElse(null);
        boolean actualInteractive = this.deriveInteractive(ar);
        CmdOp op = ar != null ? new CmdOpExec(this.invocation().asArgv().argv().get(0), ar.toArgList()) : CmdOpExec.ofLiteralArgs(this.invocation().asArgv().asArgv().argv());
        System.out.println("Interactive: " + actualInteractive);
        if (actualInteractive) {
            PathAndProcess inProcess = this.processInput(executor.inputPipe(), this.redirectInput());
            Path hostMountableInputPath = inProcess.path();
            op = CmdOps.appendRedirects(op, CmdRedirect.in(hostMountableInputPath.toString()));
        }
        op = CmdOps.appendRedirects(op, CmdRedirect.out(hostMountableOutputPath.toString()), CmdRedirect.err(hostMountableErrorPath.toString()));
        try {
            GenericContainer<?> container = this.setupContainer(op, finalFileMapper);
            Runnable runnable = () -> container.start();
            runnable.run();
            return new ProcessOverDockerContainer(container);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Process catProcess(Path source, Path target) throws IOException {
        System.out.println("cat process being set up: " + String.valueOf(source) + " -> " + String.valueOf(target));
        CmdOpExec cat = new CmdOpExec(List.of(), "cat", ArgumentList.of(CmdArg.ofPathString(source.toString()), CmdArg.redirect(CmdRedirect.out(target.toString()))));
        String scriptString = ProcessBuilderDocker.toScriptString(cat);
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", scriptString);
        Process process = pb.start();
        process.toHandle().onExit().thenRun(() -> System.out.println("cat process terminated: " + String.valueOf(source) + " -> " + String.valueOf(target)));
        return process;
    }

    private PathAndProcess processInput(Path inputPipePath, JRedirect redirect) throws IOException {
        Path rawInputPath = null;
        if (redirect instanceof JRedirect.JRedirectJava) {
            JRedirect.JRedirectJava x = (JRedirect.JRedirectJava)redirect;
            ProcessBuilder.Redirect r = x.redirect();
            switch (r.type()) {
                case INHERIT: {
                    rawInputPath = inputPipePath;
                    break;
                }
                case READ: {
                    rawInputPath = r.file().toPath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported or not implemented yet.");
                }
            }
        }
        boolean isRawInputPathMountable = ProcessBuilderDocker.isProbablyDockerBindSource(rawInputPath);
        Path hostMountableInputPath = null;
        Process pumpProcess = null;
        if (isRawInputPathMountable) {
            hostMountableInputPath = rawInputPath;
        } else {
            Path namedPipePath;
            hostMountableInputPath = namedPipePath = NamedPipe.create();
            pumpProcess = ProcessBuilderDocker.catProcess(rawInputPath, hostMountableInputPath);
        }
        return new PathAndProcess(hostMountableInputPath, pumpProcess);
    }

    private PathAndProcess processOutput(Path outputPipePath, JRedirect redirect) throws IOException {
        Path rawPath = null;
        if (redirect instanceof JRedirect.JRedirectJava) {
            JRedirect.JRedirectJava x = (JRedirect.JRedirectJava)redirect;
            ProcessBuilder.Redirect r = x.redirect();
            switch (r.type()) {
                case INHERIT: {
                    rawPath = outputPipePath;
                    break;
                }
                case WRITE: {
                    rawPath = r.file().toPath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported or not implemented yet.");
                }
            }
        }
        boolean isRawPathMountable = ProcessBuilderDocker.isProbablyDockerBindSource(rawPath);
        Path hostMountablePath = null;
        Process pumpProcess = null;
        if (isRawPathMountable) {
            hostMountablePath = rawPath;
        } else {
            Path namedPipePath;
            hostMountablePath = namedPipePath = NamedPipe.create();
            pumpProcess = ProcessBuilderDocker.catProcess(hostMountablePath, rawPath);
        }
        return new PathAndProcess(hostMountablePath, pumpProcess);
    }

    protected String getUserString() throws IOException {
        return ContainerUtils.getUserString();
    }

    public static String toScriptString(CmdOp cmdOp) {
        SysRuntime runtime = SysRuntimeImpl.forCurrentOs();
        CmdOpExec dummy = new CmdOpExec("/dummy", CmdArg.ofCommandSubstitution(cmdOp));
        CmdString cmdString = runtime.compileString(dummy);
        String scriptString = cmdString.cmd()[1];
        return scriptString;
    }

    protected GenericContainer<?> setupContainer(CmdOp rawCmdOp, FileMapper fileMapper) throws IOException {
        ExecutableInvocation exec;
        CmdOp cmdOp = CmdOpRewriter.rewriteForContainer(rawCmdOp, fileMapper);
        String userStr = this.getUserString();
        logger.info("Setting up container " + this.imageRef + " with UID:GID=" + userStr);
        String scriptString = ProcessBuilderDocker.toScriptString(cmdOp);
        Invocation.Script inv = new Invocation.Script(scriptString, "text/x-bash");
        SysRuntimeFactoryDocker sysRuntimeFactory = SysRuntimeFactoryDocker.create();
        try (SysRuntime runtime = SysRuntimeCoreLazy.of(() -> sysRuntimeFactory.create(this.imageRef));){
            CompileContext cxt = CompileContext.of((String commandName) -> {
                try {
                    String resolvedCommand = runtime.which(commandName);
                    return resolvedCommand;
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            InvocationCompiler finalCompiler = this.compiler != null ? this.compiler : InvocationCompilerImpl.getDefault();
            exec = finalCompiler.compile(inv, cxt);
        }
        List<String> tmp = exec.argv();
        String actualEntrypoint = tmp.get(0);
        String[] cmdParts = (String[])tmp.subList(1, tmp.size()).toArray(String[]::new);
        List.of(cmdParts).stream().forEach(p -> logger.info("Command part: [" + p + "]"));
        GenericContainer result = new GenericContainer(this.imageRef).withCreateContainerCmdModifier(cmd -> cmd.withUser(userStr).withEntrypoint(new String[]{actualEntrypoint})).withCommand(cmdParts).withLogConsumer(frame -> logger.info(frame.getUtf8StringWithoutLineEnding()));
        for (Bind bind : fileMapper.getBinds()) {
            result = result.withFileSystemBind(bind.getPath(), bind.getVolume().getPath(), ContainerUtils.toBindMode(bind.getAccessMode()));
            logger.info("Adding bind: " + String.valueOf(bind));
        }
        return result;
    }

    public static String extractSimpleCatPath(CmdOp cmdOp) {
        Token t;
        CmdArgWord w;
        CmdArg a;
        CmdOpExec exec;
        if (cmdOp instanceof CmdOpExec && "/virt/cat".equals((exec = (CmdOpExec)cmdOp).name()) && exec.args().size() == 1 && (a = exec.args().args().get(0)) instanceof CmdArgWord && (w = (CmdArgWord)a).tokens().size() == 1 && (t = w.tokens().get(0)) instanceof Token.TokenPath) {
            Token.TokenPath tp = (Token.TokenPath)t;
            return tp.path();
        }
        return null;
    }

    @Override
    protected ProcessBuilderDocker cloneActual() {
        ProcessBuilderDocker result = new ProcessBuilderDocker();
        this.applySettings(result);
        return result;
    }

    protected ContainerPathResolver containerPathResolver() {
        return this.containerPathResolver;
    }

    protected ProcessBuilderDocker containerPathResolver(ContainerPathResolver containerPathResolver) {
        this.containerPathResolver = containerPathResolver;
        return (ProcessBuilderDocker)this.self();
    }

    protected void applySettings(ProcessBuilderDocker target) {
        target.imageRef(this.imageRef());
        target.workingDirectory(this.workingDirectory());
        target.interactive(this.interactive());
        target.containerPathResolver(this.containerPathResolver());
        target.fileMapper(this.fileMapper());
        target.compiler(this.compiler());
        target.commandParser(this.commandParser);
    }

    private static boolean isProbablyDockerBindSource(Path p) throws IOException {
        if (!Files.exists(p, new LinkOption[0])) {
            return false;
        }
        return !PosixPipe.isAnonymousProcPipe(p);
    }

    public String toString() {
        return "ProcessBuilderDocker [imageRef=" + this.imageRef + ", invocation=" + String.valueOf(this.invocation()) + ", entrypoint=" + this.entrypoint + ", workingDirectory=" + this.workingDirectory + ", interactive=" + this.interactive + "]";
    }
}

