/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.io.pipe;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.aksw.shellgebra.exec.graph.PipeBase;
import org.newsclub.net.unix.FileDescriptorCast;

public final class PosixPipe
extends PipeBase
implements Closeable {
    private final POSIX posix;
    private final int readFd;
    private final int writeFd;
    private final FileDescriptor readFdObj;
    private final FileDescriptor writeFdObj;
    private final FileInputStream in;
    private final FileOutputStream out;

    private PosixPipe(POSIX posix, int readFd, int writeFd, FileDescriptor readFdObj, FileDescriptor writeFdObj, FileInputStream in, FileOutputStream out) {
        this.posix = posix;
        this.readFd = readFd;
        this.writeFd = writeFd;
        this.readFdObj = readFdObj;
        this.writeFdObj = writeFdObj;
        this.in = in;
        this.out = out;
    }

    public static PosixPipe open() throws IOException {
        int[] fds;
        POSIX posix = POSIXFactory.getPOSIX();
        int rc = posix.pipe(fds = new int[2]);
        if (rc != 0) {
            int errno = posix.errno();
            throw new IOException("pipe() failed, rc=" + rc + ", errno=" + errno);
        }
        int readFd = fds[0];
        int writeFd = fds[1];
        FileDescriptor readFdObj = FileDescriptorCast.unsafeUsing((int)readFd).getFileDescriptor();
        FileDescriptor writeFdObj = FileDescriptorCast.unsafeUsing((int)writeFd).getFileDescriptor();
        FileInputStream in = new FileInputStream(readFdObj);
        FileOutputStream out = new FileOutputStream(writeFdObj);
        return new PosixPipe(posix, readFd, writeFd, readFdObj, writeFdObj, in, out);
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getReadFd() {
        return this.readFd;
    }

    public int getWriteFd() {
        return this.writeFd;
    }

    public static Path procPath(int fd) {
        long pid = ProcessHandle.current().pid();
        return Path.of("/proc/", Long.toString(pid), "fd", Integer.toString(fd));
    }

    public FileDescriptor getReadFileDescriptor() {
        return this.readFdObj;
    }

    public FileDescriptor getWriteFileDescriptor() {
        return this.writeFdObj;
    }

    public Path getReadEndProcPath() {
        return PosixPipe.procPath(this.readFd);
    }

    public File getReadEndProcFile() {
        return PosixPipe.procPath(this.readFd).toFile();
    }

    public Path getWriteEndProcPath() {
        return PosixPipe.procPath(this.writeFd);
    }

    public File getWriteEndProcFile() {
        return PosixPipe.procPath(this.writeFd).toFile();
    }

    @Override
    public void close() throws IOException {
        IOException first;
        block5: {
            first = null;
            try {
                this.in.close();
            }
            catch (IOException e) {
                first = e;
            }
            try {
                this.out.close();
            }
            catch (IOException e) {
                if (first != null) break block5;
                first = e;
            }
        }
        if (first != null) {
            throw first;
        }
    }

    public static boolean isAnonymousProcPipe(Path p) throws IOException {
        if (!p.startsWith("/proc")) {
            return false;
        }
        if (!Files.isSymbolicLink(p)) {
            return false;
        }
        Path target = Files.readSymbolicLink(p);
        String s = target.toString();
        return s.matches("^(pipe|socket|anon_inode):\\[.*\\]$");
    }
}

