/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.google.common.io.ByteSource;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.shellgebra.exec.TransformedByteSource;
import org.aksw.shellgebra.exec.stage.BoundStage;
import org.aksw.shellgebra.exec.stage.BoundStageByteSource;
import org.aksw.shellgebra.exec.stage.BoundStageJvm;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.exec.stage.Stage;

public class StageJvm
implements Stage {
    private InputStreamTransform transform;

    public StageJvm(InputStreamTransform transform) {
        this.transform = Objects.requireNonNull(transform);
    }

    @Override
    public BoundStage from(ByteSource input) {
        return new BoundStageJvm(input, this.transform);
    }

    @Override
    public BoundStage from(final FileWriterTask input) {
        ByteSource bs = new ByteSource(this){

            public InputStream openStream() throws IOException {
                Path path = input.getOutputPath();
                input.start();
                InputStream in = Files.newInputStream(path, new OpenOption[0]);
                FilterInputStream result = new FilterInputStream(this, in){

                    @Override
                    public void close() throws IOException {
                        try {
                            input.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            super.close();
                        }
                    }
                };
                return result;
            }
        };
        return new BoundStageJvm(bs, this.transform);
    }

    @Override
    public BoundStage from(BoundStage input) {
        ByteSource rawByteSource = input.toByteSource();
        ByteSource byteSource = TransformedByteSource.transform(rawByteSource, this.transform);
        return new BoundStageByteSource(byteSource);
    }

    @Override
    public BoundStage fromNull() {
        return this.from(ByteSource.empty());
    }

    public String toString() {
        return "(jvmStage " + this.transform.toString() + ")";
    }
}

