/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.util.PathLifeCycle;

public abstract class FileWriterTaskBase
implements FileWriterTask {
    protected Path outputPath;
    protected PathLifeCycle pathLifeCycle;
    protected AtomicReference<TaskState> state = new AtomicReference<TaskState>(TaskState.NEW);
    protected volatile boolean isAbortCalled = false;

    public FileWriterTaskBase(Path path, PathLifeCycle pathLifeCycle) {
        this.outputPath = Objects.requireNonNull(path);
        this.pathLifeCycle = Objects.requireNonNull(pathLifeCycle);
    }

    @Override
    public Path getOutputPath() {
        return this.outputPath;
    }

    protected void checkIfNew() {
        if (this.state.get() != TaskState.NEW) {
            throw new IllegalStateException("File writing can only start once.");
        }
    }

    protected void checkIfAbortHasBeenCalled() {
        if (this.isAbortCalled) {
            throw new RuntimeException("Task aborted.");
        }
    }

    public boolean isStarted() {
        return this.state.get() == TaskState.RUNNING;
    }

    public boolean isFinished() {
        return this.state.get() == TaskState.TERMINATED;
    }

    public TaskState getState() {
        return this.state.get();
    }

    protected abstract void prepareWriteFile() throws IOException;

    protected abstract void runWriteFile() throws IOException;

    protected abstract void onCompletion() throws IOException;

    @Override
    public abstract void waitForCompletion() throws ExecutionException, InterruptedException;

    @Override
    public abstract void abort();

    public static enum TaskState {
        NEW,
        STARTING,
        RUNNING,
        TERMINATING,
        TERMINATED;

    }
}

