/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.google.common.io.ByteSource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgLiteral;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.aksw.shellgebra.exec.stage.BoundStage;
import org.aksw.shellgebra.exec.stage.ByteSourceOverPipeline;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.exec.stage.FileWriterTaskFromProcessBuilder;
import org.aksw.shellgebra.exec.stage.StageHost;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.aksw.shellgebra.util.PathLifeCycles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundStageHost
implements BoundStage {
    private static final Logger logger = LoggerFactory.getLogger(StageHost.class);
    protected CmdOp cmdOp;
    protected BoundStage inputExecBuilder = null;
    protected FileWriterTask inputTask = null;
    protected ByteSource inputSource = null;
    protected List<FileWriterTask> dependentTasks;

    public BoundStageHost(CmdOp cmdOp, ByteSource inputSource) {
        this.cmdOp = cmdOp;
        this.inputSource = inputSource;
    }

    public BoundStageHost(CmdOp cmdOp, FileWriterTask inputTask) {
        this.cmdOp = cmdOp;
        this.inputTask = inputTask;
    }

    public BoundStageHost(CmdOp cmdOp, BoundStage inputExecBuilder) {
        this.cmdOp = cmdOp;
        this.inputExecBuilder = inputExecBuilder;
    }

    public BoundStageHost(CmdOp cmdOp) {
        this.cmdOp = cmdOp;
    }

    protected List<ProcessBuilder> setupProcessBuilders(CmdOp cmdOp) {
        SysRuntime runtime = SysRuntimeImpl.forCurrentOs();
        CmdOpExec op = new CmdOpExec("/usr/bin/bash", new CmdArgLiteral("-c"), new CmdArgCmdOp(cmdOp));
        CmdString cmdString = runtime.compileString(cmdOp);
        String[] cmdParts = new String[]{"/usr/bin/bash", "-c", List.of(cmdString.cmd()).stream().collect(Collectors.joining(" "))};
        List.of(cmdParts).stream().forEach(p -> System.out.println("[" + p + "]"));
        ProcessBuilder result = new ProcessBuilder(cmdParts);
        return List.of(result);
    }

    protected FileWriterTask execToPathInternal(Path outPath, PathLifeCycle pathLifeCycle) {
        ArrayList<FileWriterTask> inputTasks = new ArrayList<FileWriterTask>();
        List<ProcessBuilder> processBuilders = this.setupProcessBuilders(this.cmdOp);
        FileWriterTaskFromProcessBuilder task = new FileWriterTaskFromProcessBuilder(outPath, pathLifeCycle, processBuilders, inputTasks, this.inputSource, null);
        return task;
    }

    @Override
    public FileWriterTask execToRegularFile(Path hostPath) {
        return this.execToFile(hostPath, PathLifeCycles.none());
    }

    @Override
    public FileWriterTask execToFile(Path hostPath, PathLifeCycle pathLifeCycle) {
        return this.execToPathInternal(hostPath, pathLifeCycle);
    }

    @Override
    public ByteSource toByteSource() {
        List<ProcessBuilder> processBuilders;
        try {
            processBuilders = this.setupProcessBuilders(this.cmdOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<FileWriterTask> subTasks = this.dependentTasks == null ? List.of() : List.copyOf(this.dependentTasks);
        ByteSourceOverPipeline result = new ByteSourceOverPipeline(processBuilders, subTasks, this.inputSource);
        return result;
    }

    @Override
    public FileWriterTask runToHostPipe() {
        PathLifeCycle pathLifeCycle = PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe());
        Path tempFile = FileMapper.allocateTempPath("", "");
        return this.execToPathInternal(tempFile, pathLifeCycle);
    }
}

