/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.util.docker.ContainerPathResolver;
import org.aksw.commons.util.docker.ContainerUtils;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOps;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransformer;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdTransformBase;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.aksw.shellgebra.exec.stage.BoundStage;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.exec.stage.FileWriterTaskFromContainer;
import org.aksw.shellgebra.exec.stage.Stage;
import org.aksw.shellgebra.processbuilder.ProcessBuilderDocker;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.aksw.shellgebra.util.PathLifeCycles;
import org.aksw.shellgebra.util.SystemUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class BoundStageDocker
implements BoundStage {
    private static final Logger logger = LoggerFactory.getLogger(BoundStageDocker.class);
    protected String imageRef;
    protected CmdOp cmdOp;
    protected Function<CmdOpVar, Stage> varResolver;
    protected List<Bind> binds;
    protected String workingDirectory;
    protected ContainerPathResolver containerPathResolver;
    protected FileMapper fileMapper;
    protected FileWriterTask inputTask;
    protected BoundStage inputExecBuilder;

    public BoundStageDocker(String imageRef, CmdOp cmdOp, FileMapper fileMapper, ContainerPathResolver containerPathResolver, FileWriterTask inputTask, BoundStage inputExecBuilder, Function<CmdOpVar, Stage> varResolver) {
        this.imageRef = imageRef;
        this.cmdOp = cmdOp;
        this.fileMapper = fileMapper;
        this.containerPathResolver = containerPathResolver;
        this.inputTask = inputTask;
        this.inputExecBuilder = inputExecBuilder;
        this.varResolver = varResolver;
    }

    protected String getUserString() throws IOException {
        int uid = SystemUtils.getUID();
        int gid = SystemUtils.getGID();
        String userStr = uid + ":" + gid;
        return userStr;
    }

    protected GenericContainer<?> setupContainer(CmdOp cmdOp) throws IOException {
        String userStr = this.getUserString();
        logger.info("Setting up container " + this.imageRef + " with UID:GID=" + userStr);
        SysRuntime runtime = SysRuntimeImpl.forCurrentOs();
        CmdOpExec dummy = new CmdOpExec("/dummy", CmdArg.ofCommandSubstitution(cmdOp));
        CmdString cmdString = runtime.compileString(dummy);
        String scriptString = cmdString.cmd()[1];
        String[] entrypoint = new String[]{"bash"};
        String[] cmdParts = new String[]{"-c", scriptString};
        List.of(cmdParts).stream().forEach(p -> logger.info("Command part: [" + p + "]"));
        GenericContainer result = new GenericContainer(this.imageRef).withCreateContainerCmdModifier(cmd -> cmd.withUser(userStr).withEntrypoint(entrypoint)).withCommand(cmdParts).withLogConsumer(frame -> logger.info(frame.getUtf8StringWithoutLineEnding()));
        for (Bind bind : this.fileMapper.getBinds()) {
            result = result.withFileSystemBind(bind.getPath(), bind.getVolume().getPath(), ContainerUtils.toBindMode(bind.getAccessMode()));
            logger.info("Adding bind: " + String.valueOf(bind));
        }
        return result;
    }

    @Override
    public ByteSource toByteSource() {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return BoundStageDocker.this.execToInputStream();
            }
        };
    }

    protected FileWriterTask execToPathInternal(Path outPath, String outContainerPath, PathLifeCycle pathLifeCycle) {
        GenericContainer<?> container;
        ArrayList<FileWriterTask> inputTasks = new ArrayList<FileWriterTask>();
        FileWriterTask itask = this.inputTask;
        if (this.inputExecBuilder != null) {
            itask = this.inputExecBuilder.runToHostPipe();
            String string = this.fileMapper.allocate(itask.getOutputPath().toAbsolutePath().toString(), AccessMode.ro);
        }
        CmdOp tmpOp = this.cmdOp;
        if (itask != null) {
            String containerPath = this.fileMapper.getContainerPath(itask.getOutputPath().toString());
            if (containerPath == null) {
                throw new RuntimeException("should not happen");
            }
            tmpOp = CmdOps.prependRedirect(tmpOp, CmdRedirect.in(containerPath));
            inputTasks.add(itask);
        }
        Set<CmdOpVar> vars = CmdOps.accVars(this.cmdOp);
        final LinkedHashMap<CmdOpVar, String> varToContainerPath = new LinkedHashMap<CmdOpVar, String>();
        for (CmdOpVar v : vars) {
            Stage stage = this.varResolver.apply(v);
            FileWriterTask fwt = stage.fromNull().runToHostPipe();
            String containerPath = this.fileMapper.getContainerPath(fwt.getOutputPath().toAbsolutePath().toString());
            Objects.requireNonNull(containerPath);
            varToContainerPath.put(v, containerPath);
            inputTasks.add(fwt);
        }
        tmpOp = CmdOpTransformer.transform(tmpOp, new CmdTransformBase(){

            @Override
            public CmdOp transform(CmdOpVar op) {
                String containerPath = (String)varToContainerPath.get(op);
                String catCommand = "cat";
                return new CmdOpExec(catCommand, ArgumentList.of(CmdArg.ofPathString(containerPath)));
            }

            @Override
            public CmdArg transform(CmdArgCmdOp arg, CmdOp subOp) {
                String path = ProcessBuilderDocker.extractSimpleCatPath(subOp);
                CmdArg r = path != null ? CmdArg.ofPathString(path) : CmdTransformBase.super.transform(arg, subOp);
                return r;
            }
        });
        CmdOp effectiveOp = CmdOps.appendRedirect(tmpOp, CmdRedirect.out(outContainerPath));
        try {
            container = this.setupContainer(effectiveOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        FileWriterTaskFromContainer task = new FileWriterTaskFromContainer(container, outPath, pathLifeCycle, inputTasks);
        return task;
    }

    @Override
    public FileWriterTask execToRegularFile(Path hostPath) {
        return this.execToFile(hostPath, PathLifeCycles.none());
    }

    @Override
    public FileWriterTask execToFile(Path hostPath, PathLifeCycle pathLifeCycle) {
        String hostPathStr = hostPath.toAbsolutePath().toString();
        this.fileMapper.allocate(hostPathStr, AccessMode.rw);
        return this.execToPathInternal(hostPath, hostPathStr, pathLifeCycle);
    }

    public InputStream execToInputStream() throws IOException {
        PathLifeCycle pathLifeCycle = PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe());
        Map.Entry<Path, String> map = this.fileMapper.allocateTempFile("", "", AccessMode.rw);
        Path outPipePath = map.getKey();
        String outContainerPath = map.getValue();
        final FileWriterTask fileWriterTask = this.execToPathInternal(outPipePath, outContainerPath, pathLifeCycle);
        fileWriterTask.start();
        InputStream in = Files.newInputStream(outPipePath, new OpenOption[0]);
        FilterInputStream result = new FilterInputStream(this, in){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    try {
                        fileWriterTask.close();
                    }
                    catch (Exception e) {
                        logger.warn("Failure during close", (Throwable)e);
                    }
                }
            }
        };
        return result;
    }

    protected void runContainerWithInputStream(ByteSource byteSource, String lang) throws InterruptedException, IOException {
        logger.info("Attempting to launch container with a JVM-based input stream.");
        GenericContainer container = this.setupContainer(null).withCreateContainerCmdModifier(cmd -> cmd.withTty(Boolean.valueOf(false)).withStdinOpen(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)));
        container.start();
        System.out.println("Waiting");
        Thread.sleep(2000L);
        System.out.println("Attaching data");
        try (InputStream in = byteSource.openStream();){
            String str = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            System.out.println(str);
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            AttachContainerCmd tmp = container.getDockerClient().attachContainerCmd(container.getContainerId()).withStdIn((InputStream)is);
            ResultCallback.Adapter<Frame> callback = new ResultCallback.Adapter<Frame>(this){

                public void onNext(Frame frame) {
                    String msg = new String(frame.getPayload(), StandardCharsets.UTF_8);
                    logger.info(msg);
                    super.onNext((Object)frame);
                }
            };
            System.out.println("Waiting");
            Thread.sleep(5000L);
            System.out.println("Awaiting completion");
            ((ResultCallback.Adapter)tmp.exec((ResultCallback)callback)).awaitCompletion();
            System.out.println("Done");
        }
        ((WaitContainerResultCallback)container.getDockerClient().waitContainerCmd(container.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitCompletion();
        container.stop();
    }

    @Override
    public FileWriterTask runToHostPipe() {
        PathLifeCycle pathLifeCycle = PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe());
        Path tempFile = FileMapper.allocateTempPath("", "");
        return this.execToFile(tempFile, pathLifeCycle);
    }
}

