/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.shell;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.aksw.shellgebra.exec.graph.FdTable;
import org.aksw.vshell.registry.PathResolutionUtils;

public class ShellEnv
implements AutoCloseable {
    private FdTable fdTable = new FdTable();
    private Map<String, String> env = new ConcurrentHashMap<String, String>();
    private String pathSeparator = ":";
    private String pathKey = "PATH";

    public FdTable getFdTable() {
        return this.fdTable;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public List<String> getPathItems() {
        return PathResolutionUtils.getPathItems(this.env, this.pathKey, this.pathSeparator);
    }

    public Stream<String> streamPathCandidates(String localName) {
        List<String> pathItems = this.getPathItems();
        return PathResolutionUtils.streamPathResolutionCandidates(pathItems, localName);
    }

    @Override
    public void close() throws Exception {
        this.fdTable.close();
    }
}

