/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.invocation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.shellgebra.exec.invocation.CompileContext;
import org.aksw.shellgebra.exec.invocation.ExecutableInvocation;
import org.aksw.shellgebra.exec.invocation.ExecutableInvocationSimple;
import org.aksw.shellgebra.exec.invocation.Invocation;
import org.aksw.shellgebra.exec.invocation.InvocationCompiler;
import org.aksw.shellgebra.exec.invocation.InvocationCompilerBase;
import org.aksw.shellgebra.exec.invocation.ScriptCompiler;
import org.aksw.shellgebra.exec.invocation.ScriptCompilerProvider;
import org.aksw.shellgebra.exec.invocation.ScriptCompilerProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationCompilerImpl
extends InvocationCompilerBase {
    private static final Logger logger = LoggerFactory.getLogger(InvocationCompilerImpl.class);
    private static InvocationCompilerImpl INSTANCE = null;
    private List<ScriptCompilerProvider> providers = new ArrayList<ScriptCompilerProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InvocationCompiler getDefault() {
        if (INSTANCE != null) return INSTANCE;
        Class<InvocationCompilerImpl> clazz = InvocationCompilerImpl.class;
        synchronized (InvocationCompilerImpl.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new InvocationCompilerImpl();
            InvocationCompilerImpl.initProviders(INSTANCE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public InvocationCompilerImpl addProvider(ScriptCompilerProvider provider) {
        this.providers.add(0, provider);
        return this;
    }

    public InvocationCompilerImpl addProvider(List<String> mediatTypes, ScriptCompiler provider) {
        this.addProvider(ScriptCompilerProviderImpl.of(mediatTypes, provider));
        return this;
    }

    public static void initProviders(InvocationCompilerImpl compiler) {
        compiler.addProvider(List.of("text/x-shellscript", "text/x-bash"), (content, mediaType, cxt) -> {
            String scriptRunnerCmd = cxt.getResolver().resolve("bash");
            return new ExecutableInvocationSimple(List.of(scriptRunnerCmd, "-c", content));
        });
    }

    @Override
    public ExecutableInvocation compile(Invocation.Script script, CompileContext ctx) {
        String mediaType = script.mediaType();
        String content = script.content();
        ExecutableInvocation result = null;
        for (ScriptCompilerProvider provider : this.providers) {
            try {
                if (!provider.supports(mediaType)) continue;
                result = provider.compile(content, mediaType, ctx);
                Objects.requireNonNull(result, "Null invocation despite supported media type " + mediaType);
                if (result == null) continue;
                break;
            }
            catch (Exception e) {
                logger.warn("Exception raised by provider", (Throwable)e);
            }
        }
        if (result == null) {
            throw new RuntimeException("Unsupported media type: " + mediaType);
        }
        return result;
    }
}

