/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aksw.shellgebra.exec.IProcessBuilder;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.graph.JRedirect;
import org.aksw.shellgebra.exec.graph.ProcessCxt;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.io.pipe.PosixPipe;
import org.aksw.vshell.registry.FileInput;
import org.aksw.vshell.registry.FileOutput;
import org.aksw.vshell.registry.JvmCommandRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunnerPosix
implements ProcessRunner {
    private static final Logger logger = LoggerFactory.getLogger(ProcessRunnerPosix.class);
    private JvmCommandRegistry jvmCmdRegistry;
    private Map<String, String> environment;
    private Path directory;
    private Path basePath;
    private PosixPipe pipeIn;
    private PosixPipe pipeOut;
    private PosixPipe pipeErr;
    private boolean inheritInFromSystem = false;
    private boolean inheritOutFromSystem = false;
    private boolean inheritErrFromSystem = false;
    private ExecutorService executorService;
    private Thread inFuture = null;
    private Thread outFuture = null;
    private Thread errFuture = null;
    private ProcessCxt cxt;

    public ProcessRunnerPosix(Path basePath, PosixPipe pipeIn, PosixPipe pipeOut, PosixPipe pipeErr, boolean inheritInFromSystem, boolean inheritOutFromSystem, boolean inheritErrFromSystem) {
        this.basePath = basePath;
        this.executorService = Executors.newCachedThreadPool();
        this.inheritInFromSystem = inheritInFromSystem;
        this.inheritOutFromSystem = inheritOutFromSystem;
        this.inheritErrFromSystem = inheritErrFromSystem;
        this.pipeIn = pipeIn;
        this.pipeOut = pipeOut;
        this.pipeErr = pipeErr;
        this.jvmCmdRegistry = new JvmCommandRegistry();
    }

    @Override
    public JvmCommandRegistry getJvmCmdRegistry() {
        return this.jvmCmdRegistry;
    }

    @Override
    public Map<String, String> environment() {
        return this.environment;
    }

    @Override
    public Path inputPipe() {
        return this.pipeIn.getReadEndProcPath();
    }

    @Override
    public Path outputPipe() {
        return this.pipeOut.getWriteEndProcPath();
    }

    @Override
    public Path errorPipe() {
        return this.pipeErr.getWriteEndProcPath();
    }

    @Override
    public FileInput internalIn() {
        return FileInput.of(this.pipeIn.getReadEndProcPath(), this.pipeIn.getInputStream());
    }

    @Override
    public FileOutput internalOut() {
        return FileOutput.of(this.pipeOut.getWriteEndProcPath(), this.pipeOut.getOutputStream());
    }

    @Override
    public FileOutput internalErr() {
        return FileOutput.of(this.pipeErr.getWriteEndProcPath(), this.pipeErr.getOutputStream());
    }

    @Override
    public PrintStream internalPrintOut() {
        return this.pipeOut.printer(StandardCharsets.UTF_8);
    }

    @Override
    public PrintStream internalPrintErr() {
        return this.pipeErr.printer(StandardCharsets.UTF_8);
    }

    @Override
    public Thread setOutputReader(Consumer<InputStream> reader) {
        Runnable runnable = () -> {
            try (InputStream in = this.getInputStream();){
                reader.accept(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.outFuture = new Thread(runnable);
        this.outFuture.start();
        return this.outFuture;
    }

    @Override
    public Thread setErrorReader(Consumer<InputStream> reader) {
        Runnable runnable = () -> {
            try (InputStream in = this.getErrorStream();){
                reader.accept(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.errFuture = new Thread(runnable);
        this.errFuture.start();
        return this.errFuture;
    }

    @Override
    public Thread setInputGenerator(Consumer<OutputStream> inputSupplier) {
        Runnable runnable = () -> {
            try (OutputStream out = this.getOutputStream();){
                inputSupplier.accept(out);
                out.flush();
                logger.info("Closing input generator file descriptor: " + String.valueOf(SysRuntime.getFdPath(((FileOutputStream)out).getFD())));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        };
        this.inFuture = new Thread(runnable);
        this.inFuture.start();
        return this.inFuture;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.pipeIn.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.pipeOut.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.pipeErr.getInputStream();
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    public static ProcessRunner create() throws IOException {
        Path basePath = Files.createTempDirectory("process-exec-", new FileAttribute[0]);
        logger.debug("Created temporary directory for named and anonymous pipes at  " + String.valueOf(basePath));
        ProcessRunner result = ProcessRunnerPosix.create(basePath);
        return result;
    }

    public static ProcessRunner create(Path basePath) throws IOException {
        return ProcessRunnerPosix.create(basePath, true, true, true);
    }

    public static ProcessRunner create(Path basePath, boolean fd0OverridesInherit, boolean fd1OverridesInherit, boolean fd2OverridesInherit) throws IOException {
        PosixPipe inPipe = PosixPipe.open();
        PosixPipe outPipe = PosixPipe.open();
        PosixPipe errPipe = PosixPipe.open();
        return new ProcessRunnerPosix(basePath, inPipe, outPipe, errPipe, fd0OverridesInherit, fd1OverridesInherit, fd2OverridesInherit);
    }

    private void cancelAndGet(CompletableFuture<?> future) throws InterruptedException, ExecutionException {
        if (future != null) {
            future.cancel(true);
            future.get();
        }
    }

    private void cancelAndGet(Thread thread) throws InterruptedException, ExecutionException {
        if (thread != null) {
            thread.interrupt();
            thread.join();
        }
    }

    @Override
    public void shutdown() throws IOException {
        try {
            this.getOutputStream().close();
        }
        finally {
            try {
                this.internalOut().close();
            }
            finally {
                this.internalErr().close();
            }
        }
    }

    @Override
    public void close() throws Exception {
        block2: {
            this.cancelAndGet(this.inFuture);
            this.internalIn().inputStream().close();
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                List<Runnable> abandonedTasks = this.executorService.shutdownNow();
                if (abandonedTasks.isEmpty()) break block2;
                logger.error("Abandoned " + abandonedTasks.size() + " tasks.");
            }
        }
        this.internalOut().outputStream().close();
        this.internalErr().outputStream().close();
        this.cancelAndGet(this.outFuture);
        this.cancelAndGet(this.errFuture);
        this.pipeIn.close();
        this.pipeOut.close();
        this.pipeErr.close();
        Files.deleteIfExists(this.basePath);
    }

    public static ProcessBuilder clone(ProcessBuilder original) {
        ProcessBuilder clone = new ProcessBuilder(new String[0]);
        clone.command(original.command());
        clone.environment().putAll(original.environment());
        clone.redirectInput(original.redirectInput());
        clone.redirectOutput(original.redirectOutput());
        clone.redirectError(original.redirectError());
        clone.directory(original.directory());
        return clone;
    }

    @Override
    public IProcessBuilder<?> configure(IProcessBuilder<?> processBuilder) {
        IProcessBuilder clone = (IProcessBuilder)processBuilder.clone();
        clone.redirectInput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.from(this.pipeIn.getReadEndProcFile())));
        clone.redirectOutput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.to(this.pipeOut.getWriteEndProcFile())));
        clone.redirectError(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.to(this.pipeIn.getWriteEndProcFile())));
        return clone;
    }
}

