/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.io.IOException;
import java.nio.file.Path;
import org.aksw.shellgebra.exec.graph.PassiveResource;
import org.aksw.shellgebra.util.PathLifeCycle;

public class PathResource
implements PassiveResource {
    private Path path;
    private PathLifeCycle lifeCycle;
    private volatile boolean isOpen = false;
    private Object lock = new Object();

    public PathResource(Path path, PathLifeCycle lifeCycle) {
        this.path = path;
        this.lifeCycle = lifeCycle;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Path getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen) {
                throw new IllegalStateException("Resource is already open");
            }
            this.lifeCycle.beforeExec(this.path);
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.isOpen = false;
            this.lifeCycle.afterExec(this.path);
        }
    }

    public String toString() {
        return String.valueOf(this.path) + "(" + (this.isOpen() ? "open" : "closed") + ")";
    }
}

