/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.aksw.commons.util.docker.Argv;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.exec.CmdStrOps;
import org.aksw.shellgebra.exec.ListBuilder;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.SysRuntimeCoreDocker;

public class SysRuntimeDocker
implements SysRuntime {
    private SysRuntimeCoreDocker core;
    private Argv locatorCommand;
    private Argv existsCommand;

    public SysRuntimeDocker(SysRuntimeCoreDocker core, Argv locatorCommand, Argv existsCommand) {
        this.core = core;
        this.locatorCommand = locatorCommand;
        this.existsCommand = existsCommand;
    }

    @Override
    public String which(String cmdName) throws IOException, InterruptedException {
        String[] argv = ListBuilder.ofString().addAll((Collection<String>)this.locatorCommand.argv()).add(cmdName).buildArray();
        String result = this.execCmd(argv);
        return result;
    }

    @Override
    public boolean exists(String cmdName) throws IOException, InterruptedException {
        String[] argv = ListBuilder.ofString().addAll((Collection<String>)this.existsCommand.argv()).add(cmdName).buildArray();
        int exitValue = this.core.runCmd(argv);
        return exitValue == 0;
    }

    protected String execCmd(String ... argv) throws UnsupportedOperationException, IOException, InterruptedException {
        String result = this.core.execCmd(argv);
        return result;
    }

    @Override
    public String quoteFileArgument(String fileName) {
        return null;
    }

    @Override
    public CmdString compileString(CmdOp op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] compileCommand(CmdOp op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CmdStrOps getStrOps() {
        return this.core.getCmdStrOps();
    }

    @Override
    public void createNamedPipe(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.core.close();
    }
}

