/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aksw.shellgebra.exec.SysRuntimeCore;
import org.aksw.shellgebra.exec.SysRuntimeCoreDocker;
import org.aksw.shellgebra.exec.SysRuntimeCoreExecSiteFactory;
import org.aksw.shellgebra.exec.SysRuntimeCoreHost;
import org.aksw.shellgebra.exec.SysRuntimeCoreJvm;
import org.aksw.shellgebra.exec.SysRuntimeCoreWrapperBase;
import org.aksw.shellgebra.exec.SysRuntimeFactoryDocker;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentHost;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentJvm;
import org.aksw.shellgebra.exec.model.ExecSiteDockerImage;
import org.aksw.shellgebra.exec.model.ExecSiteVisitor;
import org.aksw.vshell.registry.JvmCommandRegistry;
import org.apache.commons.io.IOUtils;

public class SysRuntimeCoreExecSiteFactoryPool
implements SysRuntimeCoreExecSiteFactory {
    private JvmCommandRegistry jvmCmdRegistry;
    private SysRuntimeFactoryDocker sysRuntimeDockerFactory;
    private Map<ExecSite, SysRuntimeCore> execSiteToRuntime = new ConcurrentHashMap<ExecSite, SysRuntimeCore>();

    public SysRuntimeCoreExecSiteFactoryPool(JvmCommandRegistry jvmCmdRegistry, SysRuntimeFactoryDocker sysRuntimeDockerFactory) {
        this.jvmCmdRegistry = jvmCmdRegistry;
        this.sysRuntimeDockerFactory = sysRuntimeDockerFactory;
    }

    @Override
    public SysRuntimeCore getRuntime(ExecSite execSite) {
        SysRuntimeCore core = this.execSiteToRuntime.computeIfAbsent(execSite, this::getFactory);
        return new SysRuntimeCoreWrapperBase(this, core){

            @Override
            public void close() {
            }
        };
    }

    public SysRuntimeCore getFactory(ExecSite execSite) {
        ExecSiteVisitorSysRuntimeCoreFactory visitor = new ExecSiteVisitorSysRuntimeCoreFactory();
        SysRuntimeCore result = execSite.accept(visitor);
        return result;
    }

    @Override
    public void close() {
        this.execSiteToRuntime.values().forEach(x -> IOUtils.closeQuietly((Closeable)x));
    }

    private class ExecSiteVisitorSysRuntimeCoreFactory
    implements ExecSiteVisitor<SysRuntimeCore> {
        private ExecSiteVisitorSysRuntimeCoreFactory() {
        }

        @Override
        public SysRuntimeCore visit(ExecSiteDockerImage execSite) {
            String imageRef = execSite.imageRef();
            SysRuntimeCoreDocker result = SysRuntimeCoreExecSiteFactoryPool.this.sysRuntimeDockerFactory.createCore(imageRef);
            return result;
        }

        @Override
        public SysRuntimeCore visit(ExecSiteCurrentHost execSite) {
            return new SysRuntimeCoreHost();
        }

        @Override
        public SysRuntimeCore visit(ExecSiteCurrentJvm execSite) {
            return new SysRuntimeCoreJvm(SysRuntimeCoreExecSiteFactoryPool.this.jvmCmdRegistry);
        }
    }
}

