/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.transform;

import com.github.dockerjava.api.model.AccessMode;
import java.util.Objects;
import java.util.Set;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgRedirect;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;
import org.aksw.shellgebra.algebra.cmd.op.RedirectTarget;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransformBase;

public class CmdArgTransformBindFiles
implements CmdArgTransformBase {
    private FileMapper fileMapper;

    public CmdArgTransformBindFiles(FileMapper fileMapper) {
        this.fileMapper = Objects.requireNonNull(fileMapper);
    }

    @Override
    public CmdArg transform(CmdArgRedirect arg) {
        CmdRedirect outRedirect;
        CmdRedirect inRedirect = arg.redirect();
        CmdArgRedirect result = inRedirect.equals(outRedirect = this.processRedirect(inRedirect)) ? arg : new CmdArgRedirect(outRedirect);
        return result;
    }

    protected CmdRedirect processRedirect(CmdRedirect redirect) {
        CmdRedirect cmdRedirect;
        RedirectTarget target = redirect.target();
        if (target instanceof RedirectTarget.RedirectTargetFile) {
            RedirectTarget.RedirectTargetFile f = (RedirectTarget.RedirectTargetFile)target;
            cmdRedirect = this.processRedirect(redirect, f);
        } else {
            cmdRedirect = redirect;
        }
        CmdRedirect result = cmdRedirect;
        return result;
    }

    protected CmdRedirect processRedirect(CmdRedirect redirect, RedirectTarget.RedirectTargetFile f) {
        String hostPath = f.file();
        CmdRedirect.OpenMode openMode = redirect.openMode();
        AccessMode accessMode = CmdArgTransformBindFiles.toAccessMode(openMode);
        String containerPath = this.fileMapper.allocate(hostPath, accessMode);
        CmdRedirect newRedirect = new CmdRedirect(redirect.fd(), openMode, new RedirectTarget.RedirectTargetFile(containerPath));
        return newRedirect;
    }

    public static AccessMode toAccessMode(CmdRedirect.OpenMode openMode) {
        Set<CmdRedirect.OpenMode> writeModes = Set.of(CmdRedirect.OpenMode.WRITE_TRUNCATE, CmdRedirect.OpenMode.WRITE_APPEND, CmdRedirect.OpenMode.CLOBBER);
        AccessMode result = writeModes.contains((Object)openMode) ? AccessMode.rw : AccessMode.ro;
        return result;
    }
}

