/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.op;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;
import org.aksw.shellgebra.shim.core.ArgumentList;

public interface CmdOp {
    public <T> T accept(CmdOpVisitor<T> var1);

    default public boolean isVar() {
        return false;
    }

    public static String toStrings(ArgumentList argList) {
        return CmdOp.toStrings(argList.args());
    }

    public static String toStrings(Collection<?> ... collections) {
        return Stream.of(collections).flatMap(Collection::stream).map(Object::toString).collect(Collectors.joining(" "));
    }

    public static class CmdOpVisitorPrependRedirect
    extends CmdOpVisitorModifyRedirect {
        public CmdOpVisitorPrependRedirect(List<CmdRedirect> redirects) {
            super(redirects);
        }

        @Override
        public CmdOp visit(CmdOpPipeline op) {
            List<CmdOp> subOps = op.getSubOps();
            CmdOp firstOp = subOps.get(0);
            CmdOp modifiedOp = firstOp.accept(this);
            List<CmdOp> list = Stream.concat(Stream.of(modifiedOp), subOps.subList(0, subOps.size() - 1).stream()).toList();
            CmdOpPipeline result = new CmdOpPipeline(list);
            return result;
        }
    }

    public static class CmdOpVisitorAddRedirect
    extends CmdOpVisitorModifyRedirect {
        public CmdOpVisitorAddRedirect(List<CmdRedirect> redirects) {
            super(redirects);
        }

        @Override
        public CmdOp visit(CmdOpPipeline op) {
            List<CmdOp> subOps = op.getSubOps();
            CmdOp lastOp = subOps.get(subOps.size() - 1);
            CmdOp modifiedOp = lastOp.accept(this);
            List<CmdOp> list = Stream.concat(subOps.subList(0, subOps.size() - 1).stream(), Stream.of(modifiedOp)).toList();
            CmdOpPipeline result = new CmdOpPipeline(list);
            return result;
        }
    }

    public static abstract class CmdOpVisitorModifyRedirect
    implements CmdOpVisitor<CmdOp> {
        protected List<CmdRedirect> additions;

        public CmdOpVisitorModifyRedirect(List<CmdRedirect> additions) {
            this.additions = additions;
        }

        @Override
        public CmdOp visit(CmdOpExec op) {
            ArrayList<CmdArg> newArgs = new ArrayList<CmdArg>(op.args().args());
            for (CmdRedirect redirect : this.additions) {
                newArgs.add(CmdArg.redirect(redirect));
            }
            return new CmdOpExec(op.prefixes(), op.name(), ArgumentList.of(newArgs));
        }

        public List<CmdRedirect> combine(List<CmdRedirect> base) {
            List<CmdRedirect> result = Stream.concat(base.stream(), this.additions.stream()).toList();
            return result;
        }

        @Override
        public CmdOp visit(CmdOpGroup op) {
            return new CmdOpGroup(op.subOps(), this.combine(op.redirects()));
        }

        @Override
        public CmdOp visit(CmdOpVar op) {
            return op;
        }
    }
}

