/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Container;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.aksw.commons.util.docker.HostNameUtils;
import org.aksw.shellgebra.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;

public class ContainerUtils {
    private static final Logger logger = LoggerFactory.getLogger(ContainerUtils.class);

    public static void setGlobalRetryCountIfAbsent(int retryCount) {
        String testcontainers_retryCount = System.getProperty("testcontainers.retryCount");
        if (testcontainers_retryCount == null) {
            System.setProperty("testcontainers.retryCount", Integer.toString(retryCount));
        }
    }

    public static BindMode toBindMode(AccessMode am) {
        return am == AccessMode.ro ? BindMode.READ_ONLY : BindMode.READ_WRITE;
    }

    public static String getUserString() throws IOException {
        int uid = SystemUtils.getUID();
        int gid = SystemUtils.getGID();
        String userStr = uid + ":" + gid;
        return userStr;
    }

    public static long getExitValueLong(GenericContainer<?> container) {
        InspectContainerResponse containerInfo = container.getContainerInfo();
        if (containerInfo != null && containerInfo.getState().getExitCodeLong() != null) {
            long exitValue = containerInfo.getState().getExitCodeLong();
            return exitValue;
        }
        throw new RuntimeException("No exit value");
    }

    public static int getExitValue(GenericContainer<?> container) {
        return (int)ContainerUtils.getExitValueLong(container);
    }

    public static void waitFor(GenericContainer<?> container) throws InterruptedException {
        ((WaitContainerResultCallback)container.getDockerClient().waitContainerCmd(container.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitCompletion();
    }

    private static Set<String> getContainerIdCandidates() {
        String candidate;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Path path = Paths.get("/proc/self/cgroup", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(path);
                for (String line : lines) {
                    String candidate2;
                    String[] parts = line.split("/");
                    if (parts.length <= 1 || !ContainerUtils.isLikelyContainerId(candidate2 = parts[parts.length - 1])) continue;
                    result.add(candidate2);
                }
            }
            catch (Exception e) {
                logger.warn("Error accessing " + String.valueOf(path), (Throwable)e);
            }
        }
        if (Files.exists(path = Paths.get("/proc/1/cpuset", new String[0]), new LinkOption[0])) {
            try {
                String candidate3;
                String cpuset = Files.readString(path).trim();
                String[] parts = cpuset.split("/");
                if (parts.length > 0 && ContainerUtils.isLikelyContainerId(candidate3 = parts[parts.length - 1])) {
                    result.add(candidate3);
                }
            }
            catch (Exception e) {
                logger.warn("Error accessing " + String.valueOf(path), (Throwable)e);
            }
        }
        if ((candidate = HostNameUtils.getHostName()) != null) {
            result.add(candidate);
        }
        return result;
    }

    public static InspectContainerResponse findSelfByHostname(DockerClient docker) {
        List containers = (List)docker.listContainersCmd().exec();
        String myHostName = HostNameUtils.getHostName();
        InspectContainerResponse result = null;
        for (Container container : containers) {
            InspectContainerResponse inspect = docker.inspectContainerCmd(container.getId()).exec();
            String containerHostName = inspect.getConfig().getHostName();
            if (!myHostName.equals(containerHostName)) continue;
            result = inspect;
            break;
        }
        return result;
    }

    private static boolean isLikelyContainerId(String s) {
        boolean result = s.matches("[a-f0-9]{12,64}");
        logger.info("Might be a docker container id: " + s + " -> " + result);
        return result;
    }

    public static InspectContainerResponse detectContainer(DockerClient dockerClient) {
        Set<String> candidateIds = ContainerUtils.getContainerIdCandidates();
        logger.info("Candidate container ids: " + String.valueOf(candidateIds));
        InspectContainerResponse result = null;
        for (String candidateId : candidateIds) {
            try {
                result = dockerClient.inspectContainerCmd(candidateId).exec();
                if (result == null) continue;
                break;
            }
            catch (Exception e) {
                logger.info("Inspection failed for candidate containerId " + candidateId + ". Message: " + e.getMessage() + " - trying next.");
            }
        }
        if (result == null) {
            result = ContainerUtils.findSelfByHostname(dockerClient);
        }
        if (result != null) {
            logger.info("Detected container ID: " + result.getId());
        } else {
            logger.info("No container environment detected.");
        }
        return result;
    }

    public static <T extends GenericContainer<T>> GenericContainer<T> addCurrentUserAndGroup(GenericContainer<T> container) throws IOException {
        int uid = SystemUtils.getUID();
        int gid = SystemUtils.getGID();
        logger.info("Setting up container with UID: " + uid + ", GID: " + gid);
        GenericContainer result = container.withCreateContainerCmdModifier(cmd -> cmd.withUser(uid + ":" + gid));
        return result;
    }

    public static String checkImageForCommand(String imageName, String commandName) {
        String result = ContainerUtils.checkImage(imageName, "/usr/bin/bash", "which", commandName);
        if (result == null) {
            result = ContainerUtils.checkImage(imageName, "/usr/bin/sh", "/usr/bin/which", commandName);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkImage(String imageName, String entryPoint, String whichCommand, String commandName) {
        try (GenericContainer container = new GenericContainer(imageName);){
            if (entryPoint != null) {
                container.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{entryPoint}));
            }
            container.withCommand(new String[]{whichCommand, commandName});
            container.start();
            int exitCode = container.getCurrentContainerInfo().getState().getExitCodeLong().intValue();
            if (exitCode != 0) return null;
            List<String> logs = container.getLogs().lines().toList();
            String string = logs.isEmpty() ? null : logs.get(0).trim();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean canRunEntrypoint(String imageName, String entrypoint, String ... commandPrefix) {
        return ContainerUtils.canRunEntrypoint(imageName, entrypoint, Arrays.asList(commandPrefix));
    }

    public static boolean canRunEntrypoint(String imageName, String entrypoint, List<String> commandPrefix) {
        int exitCode = ContainerUtils.runCommand(imageName, entrypoint, commandPrefix, "exit", "0");
        return exitCode == 0;
    }

    public static boolean hasCommand(String imageName, String entrypoint, List<String> commandPrefix, String command) {
        int exitCode = ContainerUtils.runCommand(imageName, entrypoint, commandPrefix, command);
        return exitCode != 127;
    }

    public static int runCommand(String imageName, String entrypoint, List<String> commandPrefix, String ... command) {
        return ContainerUtils.runCommand(imageName, entrypoint, commandPrefix, Arrays.asList(command));
    }

    public static int runCommand(String imageName, String entrypoint, List<String> commandPrefix, List<String> command) {
        String[] finalCmd;
        if (commandPrefix == null || commandPrefix.isEmpty()) {
            finalCmd = (String[])command.toArray(String[]::new);
        } else {
            ArrayList<String> parts = new ArrayList<String>(commandPrefix.size() + command.size());
            parts.addAll(commandPrefix);
            parts.addAll(command);
            finalCmd = (String[])parts.toArray(String[]::new);
        }
        try (GenericContainer container = new GenericContainer(imageName).withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{entrypoint})).withCommand(finalCmd);){
            int exitCode;
            container.start();
            int n = exitCode = container.getCurrentContainerInfo().getState().getExitCodeLong().intValue();
            return n;
        }
    }

    public static InputStream newInputStream(final GenericContainer<?> container) {
        PipedInputStream in;
        final PipedOutputStream out = new PipedOutputStream();
        try {
            in = new PipedInputStream(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        container.start();
        container.followOutput((Consumer)new Consumer<OutputFrame>(){

            @Override
            public void accept(OutputFrame outputFrame) {
                try {
                    switch (outputFrame.getType()) {
                        case END: {
                            out.close();
                            break;
                        }
                        default: {
                            byte[] arr = outputFrame.getBytes();
                            out.write(arr);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    logger.warn("Unexpected error", (Throwable)e);
                }
            }
        }, new OutputFrame.OutputType[]{OutputFrame.OutputType.STDOUT});
        FilterInputStream result = new FilterInputStream(in){

            @Override
            public void close() throws IOException {
                try {
                    container.close();
                }
                finally {
                    super.close();
                }
            }
        };
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileExistsInImage(String imageName, String pathInContainer) {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        dockerClient.inspectImageCmd(imageName).exec();
        CreateContainerResponse container = dockerClient.createContainerCmd(imageName).withCmd(new String[]{"true"}).exec();
        String containerId = container.getId();
        try {
            boolean bl;
            block13: {
                InputStream ignored = dockerClient.copyArchiveFromContainerCmd(containerId, pathInContainer).exec();
                try {
                    bl = true;
                    if (ignored == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NotFoundException e) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (IOException e) {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                ignored.close();
            }
            return bl;
        }
        finally {
            dockerClient.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
        }
    }
}

